/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.identity;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MeteorSlamSkill
extends Skill {
    private static final SkillDataManager.SkillDataKey<Float> FALL_DISTANCE = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.FLOAT);
    private static final SkillDataManager.SkillDataKey<Boolean> PROTECT_NEXT_FALL = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("03181ad0-e750-11ed-a05b-0242ac120003");
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> slamMotions;
    private final double minDistance = 6.0;

    public static float getFallDistance(SkillContainer skillContainer) {
        return skillContainer.getDataManager().getDataValue(FALL_DISTANCE).floatValue();
    }

    public static Builder createMeteorSlamBuilder() {
        return new Builder().setCategory(SkillCategories.IDENTITY).setResource(Skill.Resource.NONE).addSlamMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.METEOR_SLAM);
    }

    public MeteorSlamSkill(Builder builder) {
        super(builder);
        this.slamMotions = builder.slamMotions;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        container.getDataManager().registerData(FALL_DISTANCE);
        container.getDataManager().registerData(PROTECT_NEXT_FALL);
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            PlayerPatch<?> patt4182$temp = container.getExecuter();
            if (patt4182$temp instanceof ServerPlayerPatch) {
                Vec3 from;
                Vec3 to;
                double distance;
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)patt4182$temp;
                Skill skill = event.getSkillContainer().getSkill();
                if (skill.getCategory() != SkillCategories.BASIC_ATTACK && skill.getCategory() != SkillCategories.AIR_ATTACK) {
                    return;
                }
                if (((Player)container.getExecuter().getOriginal()).m_20096_() || ((Player)container.getExecuter().getOriginal()).m_146909_() < 40.0f) {
                    return;
                }
                CapabilityItem holdingItem = container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND);
                if (!this.slamMotions.containsKey(holdingItem.getWeaponCategory())) {
                    return;
                }
                StaticAnimation slamAnimation = this.slamMotions.get(holdingItem.getWeaponCategory()).apply(holdingItem, container.getExecuter());
                if (slamAnimation == null) {
                    return;
                }
                Vec3 vec3 = ((Player)container.getExecuter().getOriginal()).m_20299_(1.0f);
                Vec3 vec31 = ((Player)container.getExecuter().getOriginal()).m_20252_(1.0f);
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * 50.0, vec31.f_82480_ * 50.0, vec31.f_82481_ * 50.0);
                BlockHitResult hitResult = ((Player)container.getExecuter().getOriginal()).f_19853_.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, container.getExecuter().getOriginal()));
                if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = (to = hitResult.m_82450_()).m_82554_(from = ((Player)container.getExecuter().getOriginal()).m_20182_())) > this.minDistance) {
                    container.getExecuter().playAnimationSynchronized(slamAnimation, 0.0f);
                    container.getDataManager().setDataSync(FALL_DISTANCE, Float.valueOf((float)distance), (ServerPlayer)serverPlayerPatch.getOriginal());
                    container.getDataManager().setData(PROTECT_NEXT_FALL, true);
                    event.setCanceled(true);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_146707_() && container.getDataManager().getDataValue(PROTECT_NEXT_FALL).booleanValue()) {
                float stamina = container.getExecuter().getStamina();
                float damage = event.getAmount();
                event.setAmount(damage - stamina);
                event.setCanceled(true);
                container.getExecuter().setStamina(stamina - damage);
                container.getDataManager().setData(PROTECT_NEXT_FALL, false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> container.getDataManager().setData(PROTECT_NEXT_FALL, false));
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<WeaponCategory> iter = this.slamMotions.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(WeaponCategory.ENUM_MANAGER.toTranslated(iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        list.add(sb.toString());
        return list;
    }

    public static class Builder
    extends Skill.Builder<MeteorSlamSkill> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> slamMotions = Maps.newHashMap();

        public Builder addSlamMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.slamMotions.put(weaponCategory, function);
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

