/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.network.server.SPSetSkillValue;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCancelEvent;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;
import yesman.epicfight.world.item.EpicFightCreativeTabs;

public abstract class Skill {
    protected final ResourceLocation registryName;
    protected final SkillCategory category;
    protected final ActivateType activateType;
    protected final Resource resource;
    protected float consumption;
    protected int maxDuration;
    protected int maxStackSize;
    protected int requiredXp;

    public static Builder<Skill> createBuilder() {
        return new Builder<Skill>();
    }

    public static Builder<Skill> createIdentityBuilder() {
        return new Builder().setCategory(SkillCategories.IDENTITY).setResource(Resource.NONE);
    }

    public static Builder<Skill> createMoverBuilder() {
        return new Builder().setCategory(SkillCategories.MOVER).setResource(Resource.STAMINA);
    }

    public Skill(Builder<? extends Skill> builder) {
        if (builder.registryName == null) {
            IllegalArgumentException e = new IllegalArgumentException("No registry name is given for " + this.getClass().getCanonicalName());
            e.printStackTrace();
        }
        this.registryName = builder.registryName;
        this.category = builder.category;
        this.activateType = builder.activateType;
        this.resource = builder.resource;
    }

    public void setParams(CompoundTag parameters) {
        this.consumption = parameters.m_128457_("consumption");
        this.maxDuration = parameters.m_128451_("max_duration");
        this.maxStackSize = parameters.m_128441_("max_stacks") ? parameters.m_128451_("max_stacks") : 1;
        this.requiredXp = parameters.m_128451_("xp_requirement");
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        return !((Player)executer.getOriginal()).m_5833_() && !executer.isUnstable() && executer.getEntityState().canUseSkill();
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return this.checkExecuteCondition(executer);
    }

    public boolean checkExecuteCondition(PlayerPatch<?> executer) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        return new CPExecuteSkill(executer.getSkill(this).getSlotId(), CPExecuteSkill.WorkType.ACTIVATE, args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        return null;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SPSkillExecutionFeedback feedbackPacket = SPSkillExecutionFeedback.executed(executer.getSkill(this).getSlotId());
        SkillContainer container = executer.getSkill(this);
        if (executer.isChargingSkill()) {
            Skill skill = this;
            if (skill instanceof ChargeableSkill) {
                ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill);
                feedbackPacket.getBuffer().writeInt(executer.getAccumulatedChargeAmount());
                chargingSkill.castSkill(executer, container, executer.getAccumulatedChargeAmount(), feedbackPacket, false);
                executer.resetSkillCharging();
                EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)executer.getOriginal());
            }
        } else {
            SkillConsumeEvent event = new SkillConsumeEvent(executer, this, this.resource, true);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume(this, executer, event.getAmount());
            }
            container.activate();
            EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)executer.getOriginal());
        }
    }

    public void cancelOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillCancelEvent skillCancelEvent = new SkillCancelEvent(executer, executer.getSkill(this));
        executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, skillCancelEvent);
        EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.expired(executer.getSkill(this).getSlotId()), (ServerPlayer)executer.getOriginal());
    }

    public float getDefaultConsumeptionAmount(PlayerPatch<?> executer) {
        switch (this.resource) {
            case STAMINA: {
                return executer.getModifiedStaminaConsume(this.consumption);
            }
            case WEAPON_INNATE_ENERGY: {
                return executer.getSkill((Skill)this).stack;
            }
            case COOLDOWN: {
                return executer.getSkill((Skill)this).stack;
            }
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void cancelOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        SkillCancelEvent skillCancelEvent = new SkillCancelEvent(executer, executer.getSkill(this));
        executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, skillCancelEvent);
    }

    public void onInitiate(SkillContainer container) {
        container.maxDuration = this.maxDuration;
    }

    public void onRemoved(SkillContainer container) {
    }

    public void onReset(SkillContainer container) {
    }

    public void setConsumption(SkillContainer container, float value) {
        container.resource = Math.min(Math.max(value, 0.0f), container.getMaxResource());
        if (value >= container.getMaxResource()) {
            if (container.stack < this.maxStackSize) {
                ++container.stack;
                container.resource = 0.0f;
                container.prevResource = 0.0f;
            } else {
                container.resource = container.getMaxResource();
                container.prevResource = container.getMaxResource();
            }
        } else if (value == 0.0f && container.stack > 0) {
            --container.stack;
        }
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch<?> executer = container.getExecuter();
        container.prevResource = container.resource;
        container.prevDuration = container.duration;
        if (this.resource == Resource.COOLDOWN && container.stack < this.maxStackSize) {
            container.setResource(container.resource + this.getCooldownRegenPerSecond(executer) * 0.05f);
        }
        if (container.isActivated()) {
            if (this.activateType == ActivateType.DURATION) {
                --container.duration;
            }
            boolean isEnd = false;
            if (this.activateType == ActivateType.TOGGLE) {
                if (container.stack <= 0 && !((Player)executer.getOriginal()).m_7500_()) {
                    isEnd = true;
                }
            } else if (container.duration <= 0) {
                isEnd = true;
            }
            if (isEnd) {
                if (!container.getExecuter().isLogicalClient() && this.activateType != ActivateType.CHARGING) {
                    this.cancelOnServer((ServerPlayerPatch)executer, null);
                }
                container.deactivate();
            }
        }
        if (this.activateType == ActivateType.CHARGING && container.getExecuter().getChargingSkill() == this) {
            ChargeableSkill chargingSkill = (ChargeableSkill)((Object)this);
            chargingSkill.chargingTick(executer);
            if (!container.getExecuter().isLogicalClient()) {
                container.getExecuter().resetActionTick();
                if (container.getExecuter().getSkillChargingTicks(1.0f) > (float)chargingSkill.getAllowedMaxChargingTicks()) {
                    SPSkillExecutionFeedback feedbackPacket = SPSkillExecutionFeedback.executed(executer.getSkill(this).getSlotId());
                    feedbackPacket.getBuffer().writeInt(executer.getAccumulatedChargeAmount());
                    chargingSkill.castSkill((ServerPlayerPatch)executer, container, container.getExecuter().getAccumulatedChargeAmount(), feedbackPacket, true);
                    container.getExecuter().resetSkillCharging();
                    EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)container.getExecuter().getOriginal());
                }
            }
        }
    }

    public void setConsumptionSynchronize(ServerPlayerPatch executer, float amount) {
        Skill.setConsumptionSynchronize(executer, this, amount);
    }

    public void setMaxDurationSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setMaxDurationSynchronize(executer, this, amount);
    }

    public void setDurationSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setDurationSynchronize(executer, this, amount);
    }

    public void setStackSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setStackSynchronize(executer, this, amount);
    }

    public void setMaxResourceSynchronize(ServerPlayerPatch executer, float amount) {
        Skill.setMaxResourceSynchronize(executer, this, amount);
    }

    public static void setConsumptionSynchronize(ServerPlayerPatch executer, Skill skill, float amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setResource(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.COOLDOWN, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setDurationSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setDuration(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.DURATION, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setMaxDurationSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setMaxDuration(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.MAX_DURATION, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setStackSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setStack(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.STACK, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setMaxResourceSynchronize(ServerPlayerPatch executer, Skill skill, float amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setMaxResource(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.MAX_RESOURCE, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public String getTranslationKey() {
        return String.format("skill.%s.%s", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_());
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return 1.0f;
    }

    public SkillCategory getCategory() {
        return this.category;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public float getConsumption() {
        return this.consumption;
    }

    public int getRequiredXp() {
        return this.requiredXp;
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        float consumption = this.getDefaultConsumeptionAmount(playerpatch);
        SkillConsumeEvent event = new SkillConsumeEvent(playerpatch, this, this.resource, consumption, false);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, event);
        if (event.isCanceled()) {
            return false;
        }
        return event.getResourceType().predicate.canExecute(this, playerpatch, event.getAmount());
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return !((Player)executer.getOriginal()).m_7500_();
    }

    public ActivateType getActivateType() {
        return this.activateType;
    }

    public Resource getResourceType() {
        return this.resource;
    }

    public Skill getPriorSkill() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        return Lists.newArrayList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getSkillTexture() {
        ResourceLocation name = this.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "textures/gui/skills/" + name.m_135815_() + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return false;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public Component getDisplayName() {
        return new TranslatableComponent(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()));
    }

    public static class Builder<T extends Skill> {
        protected ResourceLocation registryName;
        protected SkillCategory category;
        protected ActivateType activateType;
        protected Resource resource;
        protected CreativeModeTab tab = EpicFightCreativeTabs.ITEMS;

        public Builder<T> setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder<T> setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder<T> setActivateType(ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder<T> setResource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder<T> setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public CreativeModeTab getCreativeTab() {
            return this.tab;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean isLearnable() {
            return this.category.learnable();
        }

        public boolean hasCategory(SkillCategory category) {
            return this.category == category;
        }
    }

    public static enum Resource {
        NONE((skill, playerpatch, amount) -> true, (skill, playerpatch, amount) -> {}),
        WEAPON_INNATE_ENERGY((skill, playerpatch, amount) -> amount > 0.0f, (skill, playerpatch, amount) -> {
            skill.setStackSynchronize(playerpatch, playerpatch.getSkill(skill).getStack() - 1);
            skill.setDurationSynchronize(playerpatch, skill.maxDuration);
        }),
        COOLDOWN((skill, playerpatch, amount) -> amount > 0.0f, (skill, playerpatch, amount) -> {
            skill.setConsumptionSynchronize(playerpatch, 0.0f);
            skill.setStackSynchronize(playerpatch, playerpatch.getSkill(skill).getStack() - 1);
            skill.setDurationSynchronize(playerpatch, skill.maxDuration);
        }),
        STAMINA((skill, playerpatch, amount) -> playerpatch.hasStamina(amount), (skill, playerpatch, amount) -> {
            playerpatch.consumeStamina(amount);
            skill.setDurationSynchronize(playerpatch, skill.maxDuration);
        }),
        HEALTH((skill, playerpatch, amount) -> ((Player)playerpatch.getOriginal()).m_21223_() > amount, (skill, playerpatch, amount) -> {
            ((ServerPlayer)playerpatch.getOriginal()).m_21153_(((ServerPlayer)playerpatch.getOriginal()).m_21223_() - amount);
            skill.setDurationSynchronize(playerpatch, skill.maxDuration);
        });

        public final ResourcePredicate predicate;
        public final ResourceConsumer consumer;

        private Resource(ResourcePredicate predicate, ResourceConsumer consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }

        @FunctionalInterface
        public static interface ResourcePredicate {
            public boolean canExecute(Skill var1, PlayerPatch<?> var2, float var3);
        }

        @FunctionalInterface
        public static interface ResourceConsumer {
            public void consume(Skill var1, ServerPlayerPatch var2, float var3);
        }
    }

    public static enum ActivateType {
        ONE_SHOT,
        DURATION,
        DURATION_INFINITE,
        TOGGLE,
        CHARGING;

    }
}

