/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CPModifySkillData {
    private Object value;
    private int slot;
    private int keyId;

    public CPModifySkillData() {
        this.value = null;
    }

    public CPModifySkillData(SkillDataManager.SkillDataKey<?> key, int slot, Object value) {
        this.keyId = key.getId();
        this.slot = slot;
        this.value = value;
    }

    public static CPModifySkillData fromBytes(FriendlyByteBuf buf) {
        int id = buf.readInt();
        int slot = buf.readInt();
        Object value = SkillDataManager.SkillDataKey.findById(id).getValueType().readFromBuffer(buf);
        return new CPModifySkillData(SkillDataManager.SkillDataKey.findById(id), slot, value);
    }

    public static void toBytes(CPModifySkillData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.keyId);
        buf.writeInt(msg.slot);
        SkillDataManager.SkillDataKey.findById(msg.keyId).getValueType().writeToBuffer(buf, msg.value);
    }

    public static void handle(CPModifySkillData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Object patt1599$temp = player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (patt1599$temp instanceof PlayerPatch) {
                PlayerPatch playerpatch = (PlayerPatch)patt1599$temp;
                SkillDataManager dataManager = playerpatch.getSkill(msg.slot).getDataManager();
                SkillDataManager.SkillDataKey<?> dataKey = SkillDataManager.SkillDataKey.findById(msg.keyId);
                dataManager.setDataRawtype(dataKey, msg.value);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

