/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.loot;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.forgeevent.SkillLootTableRegistryEvent;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.data.loot.function.SetSkillFunction;
import yesman.epicfight.world.item.EpicFightItems;

public class SkillBookLootModifier
extends LootModifier {
    public static final LootItemFunctionType SET_SKILL = new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new SetSkillFunction.Serializer());
    private static final Map<EntityType<?>, LootTable> SKILL_LOOT_TABLE = Maps.newHashMap();

    public static void registerLootItemFunctionType() {
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("epicfight", "set_skill"), (Object)SET_SKILL);
    }

    public static LootTable getLootTableFor(EntityType<?> entityType) {
        return SKILL_LOOT_TABLE.get(entityType);
    }

    public static void createSkillLootTable(Set<ResourceLocation> skillNames) {
        HashMap builders = Maps.newHashMap();
        SkillLootTableRegistryEvent lootTableRegistryEvent = new SkillLootTableRegistryEvent(builders);
        int modifier = (Integer)ConfigManager.SKILL_BOOK_MOB_DROP_CHANCE_MODIFIER.get();
        int dropChance = 100 + modifier;
        int antiDropChance = 100 - modifier;
        float dropChanceModifier = antiDropChance == 0 ? Float.MAX_VALUE : (float)dropChance / (float)antiDropChance;
        lootTableRegistryEvent.put(EntityType.f_20501_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:berserker", Float.valueOf(1.0f), "epicfight:stamina_pillager", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(0.5f), "epicfight:endurance"))))).put(EntityType.f_20458_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:berserker", Float.valueOf(1.0f), "epicfight:stamina_pillager", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(0.5f), "epicfight:endurance"))))).put(EntityType.f_20562_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:berserker", Float.valueOf(1.0f), "epicfight:stamina_pillager", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(0.5f), "epicfight:endurance"))))).put(EntityType.f_20524_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:swordmaster", Float.valueOf(1.0f), "epicfight:technician", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(0.5f), "epicfight:emergency_escape"))))).put(EntityType.f_20481_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:swordmaster", Float.valueOf(1.0f), "epicfight:technician", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(0.5f), "epicfight:emergency_escape"))))).put(EntityType.f_20479_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:roll", "epicfight:step", "epicfight:guard"))))).put(EntityType.f_20554_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:roll", "epicfight:step", "epicfight:guard"))))).put(EntityType.f_20558_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:hypervitality", "epicfight:impact_guard"))))).put(EntityType.f_20566_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:hypervitality", "epicfight:forbidden_strength", "epicfight:endurance", "epicfight:emergency_escape", "epicfight:parrying", "epicfight:impact_guard"))))).put(EntityType.f_20493_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:hypervitality", "epicfight:berserker", "epicfight:guard", "epicfight:step", "epicfight:roll"))))).put(EntityType.f_20513_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:hypervitality", "epicfight:stamina_pillager", "epicfight:guard", "epicfight:step", "epicfight:roll"))))).put(EntityType.f_20495_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:forbidden_strength", "epicfight:berserker"))))).put(EntityType.f_20568_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:parrying", "epicfight:impact_guard")))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.1f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:death_harvest", "epicfight:emergency_escape"))))).put(EntityType.f_20511_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:swordmaster", "epicfight:stamina_pillager", "epicfight:guard", "epicfight:step", "epicfight:roll"))))).put(EntityType.f_20512_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:hypervitality", "epicfight:parrying", "epicfight:endurance", "epicfight:impact_guard"))))).put(EntityType.f_20531_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:berserker", "epicfight:stamina_pillager", "epicfight:guard", "epicfight:step", "epicfight:roll"))))).put(EntityType.f_20497_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)(0.025f * dropChanceModifier))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder(Float.valueOf(1.0f), "epicfight:swordmaster", Float.valueOf(1.0f), "epicfight:stamina_pillager", Float.valueOf(1.0f), "epicfight:guard", Float.valueOf(1.0f), "epicfight:step", Float.valueOf(1.0f), "epicfight:roll", Float.valueOf(0.75f), "epicfight:death_harvest"))))).put(EntityType.f_20496_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).m_5577_(SetSkillFunction.builder("epicfight:death_harvest")))));
        ModLoader.get().postEvent((Event)lootTableRegistryEvent);
        builders.forEach((k, v) -> SKILL_LOOT_TABLE.put((EntityType<?>)k, v.m_79167_()));
    }

    protected SkillBookLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        LootTable lootTable = SkillBookLootModifier.getLootTableFor(entity.m_6095_());
        if (lootTable != null) {
            lootTable.m_79131_(context, generatedLoot::add);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SkillBookLootModifier> {
        public SkillBookLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            return new SkillBookLootModifier(conditionsIn);
        }

        public JsonObject write(SkillBookLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            return json;
        }
    }
}

