/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraftforge.common.ForgeConfigSpec;
import yesman.epicfight.api.utils.math.Vec2i;

public class ClientConfig {
    public final ForgeConfigSpec.IntValue longPressCountConfig;
    public final ForgeConfigSpec.BooleanValue filterAnimation;
    public final ForgeConfigSpec.DoubleValue aimHelperColor;
    public final ForgeConfigSpec.BooleanValue enableAimHelper;
    public final ForgeConfigSpec.BooleanValue cameraAutoSwitch;
    public final ForgeConfigSpec.BooleanValue autoPreparation;
    public final ForgeConfigSpec.BooleanValue offBloodEffects;
    public final ForgeConfigSpec.BooleanValue noMiningInCombat;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> battleAutoSwitchItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> miningAutoSwitchItems;
    public final ForgeConfigSpec.BooleanValue showTargetIndicator;
    public final ForgeConfigSpec.EnumValue<HealthBarShowOptions> healthBarShowOption;
    public final ForgeConfigSpec.ConfigValue<Integer> staminaBarX;
    public final ForgeConfigSpec.ConfigValue<Integer> staminaBarY;
    public final ForgeConfigSpec.EnumValue<HorizontalBasis> staminaBarXBase;
    public final ForgeConfigSpec.EnumValue<VerticalBasis> staminaBarYBase;
    public final ForgeConfigSpec.ConfigValue<Integer> weaponInnateX;
    public final ForgeConfigSpec.ConfigValue<Integer> weaponInnateY;
    public final ForgeConfigSpec.EnumValue<HorizontalBasis> weaponInnateXBase;
    public final ForgeConfigSpec.EnumValue<VerticalBasis> weaponInnateYBase;
    public final ForgeConfigSpec.ConfigValue<Integer> passivesX;
    public final ForgeConfigSpec.ConfigValue<Integer> passivesY;
    public final ForgeConfigSpec.EnumValue<HorizontalBasis> passivesXBase;
    public final ForgeConfigSpec.EnumValue<VerticalBasis> passivesYBase;
    public final ForgeConfigSpec.EnumValue<AlignDirection> passivesAlignDirection;
    public final ForgeConfigSpec.ConfigValue<Integer> chargingBarX;
    public final ForgeConfigSpec.ConfigValue<Integer> chargingBarY;
    public final ForgeConfigSpec.EnumValue<HorizontalBasis> chargingBarXBase;
    public final ForgeConfigSpec.EnumValue<VerticalBasis> chargingBarYBase;
    private static final BiFunction<Integer, Integer, Integer> ORIGIN = (screenLength, value) -> value;
    private static final BiFunction<Integer, Integer, Integer> SCREEN_EDGE = (screenLength, value) -> screenLength - value;
    private static final BiFunction<Integer, Integer, Integer> CENTER = (screenLength, value) -> screenLength / 2 + value;
    private static final BiFunction<Integer, Integer, Integer> CENTER_SAVE = (screenLength, value) -> value - screenLength / 2;
    private static final StartCoordGetter START_HORIZONTAL = (x, y, width, height, icons, horBasis, verBasis) -> {
        if (horBasis == HorizontalBasis.CENTER) {
            return new Vec2i(x - width * (icons - 1) / 2, y);
        }
        return new Vec2i(x, y);
    };
    private static final StartCoordGetter START_VERTICAL = (x, y, width, height, icons, horBasis, verBasis) -> {
        if (verBasis == VerticalBasis.CENTER) {
            return new Vec2i(x, y - height * (icons - 1) / 2);
        }
        return new Vec2i(x, y);
    };
    private static final NextCoordGetter NEXT_HORIZONTAL = (horBasis, verBasis, oldPos, width, height) -> {
        if (horBasis == HorizontalBasis.LEFT || horBasis == HorizontalBasis.CENTER) {
            return new Vec2i(oldPos.x + width, oldPos.y);
        }
        return new Vec2i(oldPos.x - width, oldPos.y);
    };
    private static final NextCoordGetter NEXT_VERTICAL = (horBasis, verBasis, oldPos, width, height) -> {
        if (verBasis == VerticalBasis.TOP || verBasis == VerticalBasis.CENTER) {
            return new Vec2i(oldPos.x, oldPos.y + height);
        }
        return new Vec2i(oldPos.x, oldPos.y - height);
    };

    public ClientConfig(ForgeConfigSpec.Builder config) {
        this.longPressCountConfig = config.defineInRange("ingame.long_press_count", 2, 1, 10);
        this.healthBarShowOption = config.defineEnum("ingame.health_bar_show_option", (Enum)HealthBarShowOptions.HURT);
        this.showTargetIndicator = config.define("ingame.show_target_indicator", () -> true);
        this.filterAnimation = config.define("ingame.filter_animation", () -> true);
        this.aimHelperColor = config.defineInRange("ingame.laser_pointer_color", 0.328125, 0.0, 1.0);
        this.enableAimHelper = config.define("ingame.enable_laser_pointer", () -> true);
        this.cameraAutoSwitch = config.define("ingame.camera_auto_switch", () -> false);
        this.autoPreparation = config.define("ingame.auto_preparation", () -> false);
        this.offBloodEffects = config.define("ingame.off_gore", () -> true);
        this.noMiningInCombat = config.define("ingame.no_mining_in_combat", () -> false);
        this.battleAutoSwitchItems = config.defineList("ingame.battle_autoswitch_items", (List)Lists.newArrayList(), element -> {
            if (element instanceof String) {
                String str = (String)element;
                return str.contains(":");
            }
            return false;
        });
        this.miningAutoSwitchItems = config.defineList("ingame.mining_autoswitch_items", (List)Lists.newArrayList(), element -> {
            if (element instanceof String) {
                String str = (String)element;
                return str.contains(":");
            }
            return false;
        });
        this.staminaBarX = config.define("ingame.ui.stamina_bar_x", (Object)120);
        this.staminaBarY = config.define("ingame.ui.stamina_bar_y", (Object)10);
        this.staminaBarXBase = config.defineEnum("ingame.ui.stamina_bar_x_base", (Enum)HorizontalBasis.RIGHT);
        this.staminaBarYBase = config.defineEnum("ingame.ui.stamina_bar_y_base", (Enum)VerticalBasis.BOTTOM);
        this.weaponInnateX = config.define("ingame.ui.weapon_innate_x", (Object)42);
        this.weaponInnateY = config.define("ingame.ui.weapon_innate_y", (Object)48);
        this.weaponInnateXBase = config.defineEnum("ingame.ui.weapon_innate_x_base", (Enum)HorizontalBasis.RIGHT);
        this.weaponInnateYBase = config.defineEnum("ingame.ui.weapon_innate_y_base", (Enum)VerticalBasis.BOTTOM);
        this.passivesX = config.define("ingame.ui.passives_x", (Object)70);
        this.passivesY = config.define("ingame.ui.passives_y", (Object)36);
        this.passivesXBase = config.defineEnum("ingame.ui.passives_x_base", (Enum)HorizontalBasis.RIGHT);
        this.passivesYBase = config.defineEnum("ingame.ui.passives_y_base", (Enum)VerticalBasis.BOTTOM);
        this.passivesAlignDirection = config.defineEnum("ingame.ui.passives_align_direction", (Enum)AlignDirection.HORIZONTAL);
        this.chargingBarX = config.define("ingame.ui.charging_bar_x", (Object)-119);
        this.chargingBarY = config.define("ingame.ui.charging_bar_y", (Object)60);
        this.chargingBarXBase = config.defineEnum("ingame.ui.charging_bar_x_base", (Enum)HorizontalBasis.CENTER);
        this.chargingBarYBase = config.defineEnum("ingame.ui.charging_bar_y_base", (Enum)VerticalBasis.CENTER);
    }

    public static enum HealthBarShowOptions {
        NONE,
        HURT,
        TARGET;


        public String toString() {
            return this.name().toLowerCase();
        }

        public HealthBarShowOptions nextOption() {
            return HealthBarShowOptions.values()[(this.ordinal() + 1) % 3];
        }
    }

    public static enum HorizontalBasis {
        LEFT(ORIGIN, ORIGIN),
        RIGHT(SCREEN_EDGE, SCREEN_EDGE),
        CENTER(CENTER, CENTER_SAVE);

        public BiFunction<Integer, Integer, Integer> positionGetter;
        public BiFunction<Integer, Integer, Integer> saveCoordGetter;

        private HorizontalBasis(BiFunction<Integer, Integer, Integer> positionGetter, BiFunction<Integer, Integer, Integer> saveCoordGetter) {
            this.positionGetter = positionGetter;
            this.saveCoordGetter = saveCoordGetter;
        }
    }

    public static enum VerticalBasis {
        TOP(ORIGIN, ORIGIN),
        BOTTOM(SCREEN_EDGE, SCREEN_EDGE),
        CENTER(CENTER, CENTER_SAVE);

        public BiFunction<Integer, Integer, Integer> positionGetter;
        public BiFunction<Integer, Integer, Integer> saveCoordGetter;

        private VerticalBasis(BiFunction<Integer, Integer, Integer> positionGetter, BiFunction<Integer, Integer, Integer> saveCoordGetter) {
            this.positionGetter = positionGetter;
            this.saveCoordGetter = saveCoordGetter;
        }
    }

    public static enum AlignDirection {
        HORIZONTAL(START_HORIZONTAL, NEXT_HORIZONTAL),
        VERTICAL(START_VERTICAL, NEXT_VERTICAL);

        public StartCoordGetter startCoordGetter;
        public NextCoordGetter nextPositionGetter;

        private AlignDirection(StartCoordGetter startCoordGetter, NextCoordGetter nextPositionGetter) {
            this.startCoordGetter = startCoordGetter;
            this.nextPositionGetter = nextPositionGetter;
        }
    }

    @FunctionalInterface
    public static interface StartCoordGetter {
        public Vec2i get(int var1, int var2, int var3, int var4, int var5, HorizontalBasis var6, VerticalBasis var7);
    }

    @FunctionalInterface
    public static interface NextCoordGetter {
        public Vec2i getNext(HorizontalBasis var1, VerticalBasis var2, Vec2i var3, int var4, int var5);
    }
}

