/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.WitherMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedWitherArmorLayer
extends PatchedLayer<WitherBoss, WitherPatch, WitherBossModel<WitherBoss>, WitherArmorLayer, WitherMesh> {
    private static final ResourceLocation WITHER_ARMOR_LOCATION = new ResourceLocation("textures/entity/wither/wither_armor.png");

    public PatchedWitherArmorLayer() {
        super(Meshes.WITHER);
    }

    @Override
    protected void renderLayer(WitherPatch entitypatch, WitherBoss entityliving, WitherArmorLayer vanillaLayer, PoseStack matrixStackIn, MultiBufferSource buffer, int packedLightIn, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        if (entitypatch.isArmorActivated()) {
            float progress = (float)entityliving.f_19797_ + partialTicks;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, -0.1, 0.0);
            matrixStackIn.m_85841_(1.05f, 1.05f, 1.05f);
            int transparencyCount = entitypatch.getTransparency();
            float transparency = 1.0f;
            if (transparencyCount == 0) {
                transparency = entitypatch.isGhost() ? 0.0f : 1.0f;
                AnimationPlayer animationPlayer = ((Animator)entitypatch.getAnimator()).getPlayerFor(null);
                if (animationPlayer.getAnimation() == Animations.WITHER_SPELL_ARMOR) {
                    transparency = (animationPlayer.getPrevElapsedTime() + (animationPlayer.getElapsedTime() - animationPlayer.getPrevElapsedTime()) * partialTicks) / (Animations.WITHER_SPELL_ARMOR.getTotalTime() - 0.5f);
                }
            } else if (transparencyCount < 0) {
                transparency = 1.0f - ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
            } else if (transparencyCount > 0) {
                transparency = ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
            }
            VertexConsumer ivertexbuilder = buffer.m_6299_(EpicFightRenderTypes.triangles(RenderType.m_110436_((ResourceLocation)WITHER_ARMOR_LOCATION, (float)(Mth.m_14089_((float)(progress * 0.02f)) * 3.0f % 1.0f), (float)(progress * 0.01f % 1.0f))));
            ((WitherMesh)this.mesh).drawModelWithPose(matrixStackIn, ivertexbuilder, packedLightIn, transparency * 0.5f, transparency * 0.5f, transparency * 0.5f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), poses);
            matrixStackIn.m_85849_();
        }
    }
}

