/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.mesh.WitherMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedWitherArmorLayer;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@OnlyIn(value=Dist.CLIENT)
public class PWitherRenderer
extends PatchedLivingEntityRenderer<WitherBoss, WitherPatch, WitherBossModel<WitherBoss>, WitherMesh> {
    public static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = new ResourceLocation("textures/entity/wither/wither.png");

    public PWitherRenderer() {
        this.addPatchedLayer(WitherArmorLayer.class, new PatchedWitherArmorLayer());
    }

    @Override
    public void render(WitherBoss entityIn, WitherPatch entitypatch, LivingEntityRenderer<WitherBoss, WitherBossModel<WitherBoss>> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisible = this.isVisible(entityIn, entitypatch);
        boolean isVisibleToPlayer = !isVisible && !entityIn.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_((Entity)entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        WitherMesh mesh = this.getMesh(entitypatch);
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (renderType != null) {
            int transparencyCount = entitypatch.getTransparency();
            if (transparencyCount == 0) {
                if (!entitypatch.isGhost()) {
                    VertexConsumer builder = buffer.m_6299_(renderType);
                    mesh.drawModelWithPose(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), armature, poseMatrices);
                }
            } else {
                float transparency = ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
                if (transparencyCount < 0) {
                    transparency = 1.0f - transparency;
                }
                renderType = EpicFightRenderTypes.triangles(RenderType.m_110473_((ResourceLocation)WITHER_LOCATION));
                VertexConsumer builder1 = buffer.m_6299_(renderType);
                mesh.drawModelWithPose(poseStack, builder1, packedLight, 1.0f, 1.0f, 1.0f, transparency, OverlayTexture.f_118083_, armature, poseMatrices);
                renderType = EpicFightRenderTypes.triangles(RenderType.m_110473_((ResourceLocation)WITHER_INVULNERABLE_LOCATION));
                VertexConsumer builder2 = buffer.m_6299_(renderType);
                mesh.drawModelWithPose(poseStack, builder2, packedLight, 1.0f, 1.0f, 1.0f, Mth.m_14031_((float)(transparency * 3.1415f)), OverlayTexture.f_118083_, armature, poseMatrices);
            }
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer.Priority priority : Layer.Priority.HIGHEST.lowers()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    protected boolean isVisible(WitherBoss witherboss, WitherPatch witherpatch) {
        return !witherpatch.isGhost() || witherpatch.getTransparency() != 0;
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, WitherBoss witherboss, WitherPatch entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, witherboss, entitypatch, partialTicks);
        float f = 1.0f;
        int i = witherboss.m_31502_();
        if (i > 0) {
            f -= ((float)i - partialTicks) / 440.0f;
        }
        poseStack.m_85841_(f, f, f);
    }

    @Override
    protected void setJointTransforms(WitherPatch entitypatch, Armature armature, float partialTicks) {
        this.setJointTransform("Head_M", armature, entitypatch.getHeadMatrix(partialTicks));
        WitherBoss witherBoss = (WitherBoss)entitypatch.getOriginal();
        float leftHeadYRot = witherBoss.f_31426_[0] + (witherBoss.f_31424_[0] - witherBoss.f_31426_[0]) * partialTicks;
        float rightHeadYRot = witherBoss.f_31426_[1] + (witherBoss.f_31424_[1] - witherBoss.f_31426_[1]) * partialTicks;
        float leftHeadXRot = witherBoss.f_31425_[0] + (witherBoss.f_31423_[0] - witherBoss.f_31425_[0]) * partialTicks;
        float rightHeadXRot = witherBoss.f_31425_[1] + (witherBoss.f_31423_[1] - witherBoss.f_31425_[1]) * partialTicks;
        this.setJointTransform("Head_R", armature, OpenMatrix4f.createRotatorDeg(witherBoss.f_20883_ - rightHeadYRot, Vec3f.Y_AXIS).rotateDeg(-rightHeadXRot, Vec3f.X_AXIS));
        this.setJointTransform("Head_L", armature, OpenMatrix4f.createRotatorDeg(witherBoss.f_20883_ - leftHeadYRot, Vec3f.Y_AXIS).rotateDeg(-leftHeadXRot, Vec3f.X_AXIS));
    }

    @Override
    public WitherMesh getMesh(WitherPatch entitypatch) {
        return Meshes.WITHER;
    }
}

