/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.world.level.block.entity.FractureBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class FractureBlockRenderer
implements BlockEntityRenderer<FractureBlockEntity> {
    static final Direction[] DIRECTIONS = Direction.values();
    private final BlockRenderDispatcher blockRenderDispatcher;

    public FractureBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.m_173584_();
    }

    public boolean shouldRender(FractureBlockEntity p_173568_, Vec3 p_173569_) {
        return Vec3.m_82512_((Vec3i)p_173568_.m_58899_()).m_82509_((Position)p_173569_, (double)this.m_142163_());
    }

    public void render(FractureBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int lightColor, int overlayColor) {
        float turnBackTime = 5.0f;
        float lerpAmount = Mth.m_14036_((float)(partialTicks * (1.0f / turnBackTime) + (turnBackTime - (float)(blockEntity.getMaxLifeTime() - blockEntity.getLifeTime())) * (1.0f / turnBackTime)), (float)0.0f, (float)1.0f);
        Vector3f translate = (float)blockEntity.getMaxLifeTime() > (float)blockEntity.getLifeTime() + turnBackTime ? blockEntity.getTranslate() : MathUtils.lerpMojangVector(blockEntity.getTranslate(), Vector3f.f_176763_, lerpAmount);
        Quaternion rotate = (float)blockEntity.getMaxLifeTime() > (float)blockEntity.getLifeTime() + turnBackTime ? blockEntity.getRotation() : MathUtils.lerpQuaternion(blockEntity.getRotation(), Quaternion.f_80118_, lerpAmount);
        double BOUNCE_MAX_HEIGHT = blockEntity.getBouncing();
        double TIME = Math.max(BOUNCE_MAX_HEIGHT * 8.0, 8.0);
        double EXTENDER = 1.0 / Math.pow(TIME * 0.5, 2.0);
        double MOVE_GRAPH = Math.sqrt(BOUNCE_MAX_HEIGHT / EXTENDER);
        double bouncingAnimation = Math.max(-EXTENDER * Math.pow((double)((float)blockEntity.getLifeTime() + partialTicks) - MOVE_GRAPH, 2.0) + BOUNCE_MAX_HEIGHT, 0.0);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(rotate);
        poseStack.m_85837_((double)translate.m_122239_(), (double)translate.m_122260_() + bouncingAnimation, (double)translate.m_122269_());
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        this.blockRenderDispatcher.renderBreakingTexture(blockEntity.getOriginalBlockState(), blockEntity.m_58899_().m_7494_(), (BlockAndTintGetter)blockEntity.m_58904_(), poseStack, multiBufferSource.m_6299_(RenderType.m_110463_()), (IModelData)EmptyModelData.INSTANCE);
        poseStack.m_85849_();
    }
}

