/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.screen.UISetupScreen;
import yesman.epicfight.client.gui.widget.UIComponentPop;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.config.Option;

@OnlyIn(value=Dist.CLIENT)
public class UIComponent
extends Button {
    protected final UISetupScreen parentScreen;
    protected final ResourceLocation texture;
    protected int texU;
    protected int texV;
    protected int texW;
    protected int texH;
    protected int resolutionDivW;
    protected int resolutionDivH;
    protected int draggingTime;
    protected float r;
    protected float g;
    protected float b;
    private double pressX;
    private double pressY;
    public final Option<Integer> xCoord;
    public final Option<Integer> yCoord;
    public final Option<ClientConfig.HorizontalBasis> horizontalBasis;
    public final Option<ClientConfig.VerticalBasis> verticalBasis;
    public UIComponentPop<?> popupScreen;

    public UIComponent(int x, int y, Option<Integer> xCoord, Option<Integer> yCoord, Option<ClientConfig.HorizontalBasis> horizontalBasis, Option<ClientConfig.VerticalBasis> verticalBasis, int width, int height, int texU, int texV, int texW, int texH, int resolutionDivW, int resolutionDivH, int r, int g, int b, UISetupScreen parentScreen, ResourceLocation texture) {
        super(x, y, width, height, (Component)new TextComponent(""), button -> {}, f_93716_);
        this.texture = texture;
        this.texU = texU;
        this.texV = texV;
        this.texW = texW;
        this.texH = texH;
        this.resolutionDivW = resolutionDivW;
        this.resolutionDivH = resolutionDivH;
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.horizontalBasis = horizontalBasis;
        this.verticalBasis = verticalBasis;
        this.parentScreen = parentScreen;
        this.popupScreen = new UIComponentPop<UIComponent>(30, 30, this);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_) {
            if (this.m_7972_(button)) {
                this.draggingTime = 0;
                if (this.m_93680_(mouseX, mouseY)) {
                    this.parentScreen.beginToDrag(this);
                    this.pressX = mouseX - (double)this.f_93620_;
                    this.pressY = mouseY - (double)this.f_93621_;
                    this.m_7435_(Minecraft.m_91087_().m_91106_());
                    if (!this.popupScreen.isHoverd(this.f_93620_, this.f_93621_)) {
                        this.popupScreen.closePop();
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected void m_7212_(double x, double y, double dx, double dy) {
        if (this.parentScreen.isDraggingComponent(this)) {
            this.f_93620_ = (int)(x - this.pressX);
            this.f_93621_ = (int)(y - this.pressY);
            ++this.draggingTime;
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7972_(button)) {
            this.m_7691_(mouseX, mouseY);
            this.parentScreen.endDragging();
            int xCoord = this.horizontalBasis.getValue().saveCoordGetter.apply(this.parentScreen.f_96543_, this.f_93620_);
            int yCoord = this.verticalBasis.getValue().saveCoordGetter.apply(this.parentScreen.f_96544_, this.f_93621_);
            this.xCoord.setValue(xCoord);
            this.yCoord.setValue(yCoord);
            return true;
        }
        return false;
    }

    public void m_7691_(double x, double y) {
        if (!this.popupScreen.isOpen() && this.draggingTime < 2) {
            this.popupScreen.x = x + (double)this.popupScreen.f_96543_ > (double)this.parentScreen.f_96543_ ? (int)x - this.popupScreen.f_96543_ : (int)x;
            this.popupScreen.y = y + (double)this.popupScreen.f_96544_ > (double)this.parentScreen.f_96544_ ? (int)y - this.popupScreen.f_96544_ : (int)y;
            this.popupScreen.openPop();
        }
    }

    public void drawOutline(PoseStack poseStack) {
        float screenX = this.f_93620_ - 1;
        float screenXEnd = this.f_93620_ + this.f_93618_ + 1;
        float screenY = this.f_93621_ - 1;
        float screenYEnd = this.f_93621_ + this.f_93619_ + 1;
        RenderSystem.m_69464_();
        RenderSystem.m_69832_((float)2.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenXEnd, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenXEnd, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenXEnd, screenYEnd, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenXEnd, screenYEnd, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenYEnd, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenYEnd, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        if (this.horizontalBasis.getValue() == ClientConfig.HorizontalBasis.CENTER) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX + (screenXEnd - screenX) / 2.0f, screenY + (screenYEnd - screenY) / 2.0f, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.parentScreen.f_96543_ / 2), screenY + (screenYEnd - screenY) / 2.0f, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        } else if (this.horizontalBasis.getValue() == ClientConfig.HorizontalBasis.LEFT) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        } else if (this.horizontalBasis.getValue() == ClientConfig.HorizontalBasis.RIGHT) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.parentScreen.f_96543_, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (this.verticalBasis.getValue() == ClientConfig.VerticalBasis.CENTER) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX + (screenXEnd - screenX) / 2.0f, screenY + (screenYEnd - screenY) / 2.0f, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX + (screenXEnd - screenX) / 2.0f, (float)(this.parentScreen.f_96544_ / 2), 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        } else if (this.verticalBasis.getValue() == ClientConfig.VerticalBasis.TOP) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, 0.0f, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        } else if (this.verticalBasis.getValue() == ClientConfig.VerticalBasis.BOTTOM) {
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, screenY, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_85982_(poseStack.m_85850_().m_85861_(), screenX, (float)this.parentScreen.f_96544_, 0.0f).m_6122_(69, 166, 244, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public void m_6303_(PoseStack poseStack, int x, int y, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_157429_((float)this.r, (float)this.g, (float)this.b, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        GuiComponent.m_93160_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)this.texU, (float)this.texV, (int)this.texW, (int)this.texH, (int)this.resolutionDivW, (int)this.resolutionDivH);
        if (this.m_198029_() || this.popupScreen.isOpen()) {
            this.drawOutline(poseStack);
        }
        if (this.popupScreen.isOpen()) {
            this.popupScreen.m_6305_(poseStack, x, y, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PassiveUIComponent
    extends UIComponent {
        public final Option<ClientConfig.AlignDirection> alignDirection;
        protected final ResourceLocation texture2;

        public PassiveUIComponent(int x, int y, Option<Integer> xCoord, Option<Integer> yCoord, Option<ClientConfig.HorizontalBasis> horizontalBasis, Option<ClientConfig.VerticalBasis> verticalBasis, Option<ClientConfig.AlignDirection> alignDirection, int width, int height, int texU, int texV, int texW, int texH, int resolutionDivW, int resolutionDivH, int r, int g, int b, UISetupScreen parentScreen, ResourceLocation texture, ResourceLocation texture2) {
            super(x, y, xCoord, yCoord, horizontalBasis, verticalBasis, width, height, texU, texV, texW, texH, resolutionDivW, resolutionDivH, r, g, b, parentScreen, texture);
            this.popupScreen = new UIComponentPop.PassivesUIComponentPop(30, 44, this);
            this.alignDirection = alignDirection;
            this.texture2 = texture2;
        }

        @Override
        public void m_6303_(PoseStack poseStack, int x, int y, float partialTicks) {
            Vec2i startPos = this.alignDirection.getValue().startCoordGetter.get(this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, 2, (ClientConfig.HorizontalBasis)((Object)this.horizontalBasis.getValue()), (ClientConfig.VerticalBasis)((Object)this.verticalBasis.getValue()));
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            RenderSystem.m_157429_((float)this.r, (float)this.g, (float)this.b, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)startPos.x, (int)startPos.y, (int)this.f_93618_, (int)this.f_93619_, (float)this.texU, (float)this.texV, (int)this.texW, (int)this.texH, (int)this.resolutionDivW, (int)this.resolutionDivH);
            if (this.m_198029_() || this.popupScreen.isOpen()) {
                this.drawOutline(poseStack);
            }
            if (this.popupScreen.isOpen()) {
                this.popupScreen.m_6305_(poseStack, x, y, partialTicks);
            }
            Vec2i nextPos = this.alignDirection.getValue().nextPositionGetter.getNext((ClientConfig.HorizontalBasis)((Object)this.horizontalBasis.getValue()), (ClientConfig.VerticalBasis)((Object)this.verticalBasis.getValue()), startPos, this.f_93618_, this.f_93619_);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture2);
            RenderSystem.m_157429_((float)this.r, (float)this.g, (float)this.b, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)nextPos.x, (int)nextPos.y, (int)this.f_93618_, (int)this.f_93619_, (float)this.texU, (float)this.texV, (int)this.texW, (int)this.texH, (int)this.resolutionDivW, (int)this.resolutionDivH);
        }
    }
}

