/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.EditItemListScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;

@OnlyIn(value=Dist.CLIENT)
public class EditSwitchingItemScreen
extends Screen {
    private RegisteredItemList battleAutoSwitchItems;
    private RegisteredItemList miningAutoSwitchItems;
    protected final Screen parentScreen;
    private Runnable deferredTooltip;

    public EditSwitchingItemScreen(Screen parentScreen) {
        super((Component)new TranslatableComponent("epicfight.gui.configuration.autoswitching"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        if (this.battleAutoSwitchItems == null) {
            this.battleAutoSwitchItems = new RegisteredItemList(this.f_96541_, 200, this.f_96544_, (Component)new TranslatableComponent("epicfight.gui.to_battle_mode"), EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems);
        } else {
            this.battleAutoSwitchItems.resize(200, this.f_96544_);
        }
        if (this.miningAutoSwitchItems == null) {
            this.miningAutoSwitchItems = new RegisteredItemList(this.f_96541_, 200, this.f_96544_, (Component)new TranslatableComponent("epicfight.gui.to_mining_mode"), EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems);
        } else {
            this.miningAutoSwitchItems.resize(200, this.f_96544_);
        }
        this.battleAutoSwitchItems.m_93507_(this.f_96543_ / 2 - 204);
        this.miningAutoSwitchItems.m_93507_(this.f_96543_ / 2 + 4);
        this.m_142416_((GuiEventListener)this.battleAutoSwitchItems);
        this.m_142416_((GuiEventListener)this.miningAutoSwitchItems);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 28, 160, 20, CommonComponents.f_130655_, button -> {
            EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems.clear();
            EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems.clear();
            this.battleAutoSwitchItems.toList().forEach(item -> EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems.add((Item)item));
            this.miningAutoSwitchItems.toList().forEach(item -> EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems.add((Item)item));
            EpicFightMod.CLIENT_INGAME_CONFIG.save();
            this.m_7379_();
        }));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        this.battleAutoSwitchItems.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.miningAutoSwitchItems.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        EditSwitchingItemScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        if (this.deferredTooltip != null) {
            this.deferredTooltip.run();
            this.deferredTooltip = null;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegisteredItemList
    extends ObjectSelectionList<ItemEntry> {
        private final Component title;

        public RegisteredItemList(Minecraft mcIn, int width, int height, Component title, List<Item> saved) {
            super(mcIn, width, height, 32, height - 50, 22);
            this.title = title;
            this.m_93473_(true, 13);
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((ItemEntry)this.m_93511_()));
            }
            this.m_7085_((AbstractSelectionList.Entry)new ButtonInEntry());
            for (Item item : saved) {
                this.m_7085_((AbstractSelectionList.Entry)new ItemEntry(item));
            }
        }

        public void resize(int width, int height) {
            this.f_93388_ = width;
            this.f_93389_ = height;
            this.f_93390_ = 32;
            this.f_93391_ = height - 50;
            this.f_93393_ = 0;
            this.f_93392_ = width;
        }

        protected void m_7154_(PoseStack matrixStack, int x, int y, Tesselator tessellator) {
            MutableComponent Component2 = new TextComponent("").m_7220_(this.title).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BOLD});
            this.f_93386_.f_91062_.m_92889_(matrixStack, (Component)Component2, (float)(x + this.f_93388_ / 2 - this.f_93386_.f_91062_.m_92852_((FormattedText)Component2) / 2), (float)Math.min(this.f_93390_ + 3, y), 0xFFFFFF);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        protected void addEntry(Item item) {
            this.m_6702_().add(new ItemEntry(item));
        }

        protected void removeIfPresent(Item item) {
            this.m_6702_().remove((Object)new ItemEntry(item));
        }

        protected List<Item> toList() {
            ArrayList list = Lists.newArrayList();
            for (ItemEntry entry : this.m_6702_()) {
                if (entry.item == null) continue;
                list.add(entry.item);
            }
            return list;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ItemEntry
        extends ObjectSelectionList.Entry<ItemEntry> {
            private Item item;

            public ItemEntry(Item item) {
                this.item = item;
            }

            public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                try {
                    EditSwitchingItemScreen.this.f_96542_.m_115123_(new ItemStack((ItemLike)this.item), left + 4, top + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Component Component2 = this.item.m_7626_(ItemStack.f_41583_);
                ((RegisteredItemList)RegisteredItemList.this).f_93386_.f_91062_.m_92889_(matrixStack, Component2, (float)(left + 30), (float)top + 5.0f, 0xFFFFFF);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegisteredItemList.this.m_93511_() != null && ((ItemEntry)RegisteredItemList.this.m_93511_()).equals((Object)this)) {
                        RegisteredItemList.this.m_93502_((AbstractSelectionList.Entry)this);
                        return false;
                    }
                    RegisteredItemList.this.m_6987_((AbstractSelectionList.Entry)this);
                    return true;
                }
                return false;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemEntry && !(this instanceof ButtonInEntry)) {
                    return this.item.equals(((ItemEntry)((Object)obj)).item);
                }
                return super.equals(obj);
            }

            public Component m_142172_() {
                return new TranslatableComponent("narrator.select", new Object[]{this.item != null ? this.item.m_7626_(ItemStack.f_41583_) : ""});
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonInEntry
        extends ItemEntry {
            private Button addItemButton;
            private Button removeAllButton;
            private Button automaticRegisterButton;

            public ButtonInEntry() {
                super(null);
                this.addItemButton = new Button(0, 0, 20, 20, (Component)new TextComponent("+"), button -> {
                    RegisteredItemList thisList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.battleAutoSwitchItems : EditSwitchingItemScreen.this.miningAutoSwitchItems;
                    RegisteredItemList opponentList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.miningAutoSwitchItems : EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    RegisteredItemList.this.f_93386_.m_91152_((Screen)new EditItemListScreen(EditSwitchingItemScreen.this, thisList, opponentList));
                }, Button.f_93716_);
                this.removeAllButton = new Button(0, 0, 60, 20, (Component)new TranslatableComponent("epicfight.gui.delete_all"), button -> {
                    RegisteredItemList.this.m_93516_();
                    RegisteredItemList.this.m_7085_((AbstractSelectionList.Entry)this);
                }, Button.f_93716_);
                this.automaticRegisterButton = new Button(0, 0, 60, 20, (Component)new TranslatableComponent("epicfight.gui.auto_add"), button -> {
                    boolean isBattleTab;
                    boolean bl = isBattleTab = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    if (isBattleTab) {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            if (!ItemCapabilityProvider.has(item)) continue;
                            ItemEntry itemEntry = new ItemEntry(item);
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.m_6702_().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.battleAutoSwitchItems.m_7085_((AbstractSelectionList.Entry)itemEntry);
                        }
                    } else {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            ItemEntry itemEntry = new ItemEntry(item);
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.m_6702_().contains((Object)itemEntry) || EditSwitchingItemScreen.this.miningAutoSwitchItems.m_6702_().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.miningAutoSwitchItems.m_7085_((AbstractSelectionList.Entry)itemEntry);
                        }
                    }
                }, (button, matrixStack, mouseX, mouseY) -> {
                    String tooltip;
                    boolean isBattleTab = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    String string = tooltip = isBattleTab ? "epicfight.gui.tooltip_battle" : "epicfight.gui.tooltip_mining";
                    if (isBattleTab) {
                        EditSwitchingItemScreen.this.deferredTooltip = () -> EditSwitchingItemScreen.this.m_96617_(matrixStack, ((EditSwitchingItemScreen)EditSwitchingItemScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent(tooltip), Math.max(EditSwitchingItemScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                    } else {
                        EditSwitchingItemScreen.this.m_96617_(matrixStack, ((EditSwitchingItemScreen)EditSwitchingItemScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent(tooltip), Math.max(EditSwitchingItemScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                    }
                });
            }

            @Override
            public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.addItemButton.f_93620_ = left + 25;
                this.addItemButton.f_93621_ = top - 2;
                this.addItemButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                this.removeAllButton.f_93620_ = left + 47;
                this.removeAllButton.f_93621_ = top - 2;
                this.removeAllButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                this.automaticRegisterButton.f_93620_ = left + 109;
                this.automaticRegisterButton.f_93621_ = top - 2;
                this.automaticRegisterButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (this.addItemButton.m_5953_(mouseX, mouseY)) {
                        this.addItemButton.m_7435_(Minecraft.m_91087_().m_91106_());
                        this.addItemButton.m_5691_();
                    }
                    if (this.removeAllButton.m_5953_(mouseX, mouseY)) {
                        this.removeAllButton.m_7435_(Minecraft.m_91087_().m_91106_());
                        this.removeAllButton.m_5691_();
                    }
                    if (this.automaticRegisterButton.m_5953_(mouseX, mouseY)) {
                        this.automaticRegisterButton.m_7435_(Minecraft.m_91087_().m_91106_());
                        this.automaticRegisterButton.m_5691_();
                    }
                }
                return false;
            }
        }
    }
}

