/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.screen.IngameConfigurationScreen;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillExecuteEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private Map<KeyMapping, BiConsumer<KeyMapping, Integer>> keyFunctions = Maps.newHashMap();
    private Set<Object> packets = Sets.newHashSet();
    private Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private KeyBindingMap keyHash;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean chargeKeyUnpressed;
    private int reserveCounter;
    private KeyMapping reservedKey;
    private SkillSlot reservedOrChargingSkillSlot;
    private KeyMapping currentChargingKey;
    public Options options;

    public ControllEngine() {
        Events.controllEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
        this.keyFunctions.put(EpicFightKeyMappings.ATTACK, this::attackKeyPressed);
        this.keyFunctions.put(this.options.f_92093_, this::swapHandKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.SWITCH_MODE, this::switchModeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.DODGE, this::dodgeKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.GUARD, this::guardPressed);
        this.keyFunctions.put(EpicFightKeyMappings.WEAPON_INNATE_SKILL, this::weaponInnateSkillKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.MOVER_SKILL, this::moverKeyPressed);
        this.keyFunctions.put(EpicFightKeyMappings.LOCK_ON, this::lockonPressed);
        try {
            this.keyHash = (KeyBindingMap)ObfuscationReflectionHelper.findField(KeyMapping.class, (String)"f_90810_").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerPatch(LocalPlayerPatch playerpatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_108633_();
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_108633_();
    }

    private void attackKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode() && this.currentChargingKey != key && !Minecraft.m_91087_().m_91104_()) {
            if (this.options.f_92096_.getKey() == EpicFightKeyMappings.ATTACK.getKey()) {
                this.setKeyBind(this.options.f_92096_, false);
                while (this.options.f_92096_.m_90859_()) {
                }
            }
            if (!EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
                SkillSlots slot;
                SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.05 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
                if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.player.m_36334_();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                    this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (!this.weaponInnatePressToggle) {
                this.weaponInnatePressToggle = true;
            }
        }
    }

    private void dodgeKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode() && this.currentChargingKey != key) {
            if (key.getKey().m_84873_() == this.options.f_92090_.getKey().m_84873_()) {
                if (this.player.m_20202_() == null && !this.sneakPressToggle) {
                    this.sneakPressToggle = true;
                }
            } else {
                SkillSlots skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillCategory);
                if (skill.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                    this.reserveKey(SkillSlots.DODGE, key);
                }
            }
        }
    }

    private void guardPressed(KeyMapping key, int action) {
        if (action == 1) {
            // empty if block
        }
    }

    private void swapHandKeyPressed(KeyMapping key, int action) {
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            while (key.m_90859_()) {
            }
            this.setKeyBind(key, false);
        }
    }

    private void switchModeKeyPressed(KeyMapping key, int action) {
        if (action == 1 && ((LocalPlayer)this.playerpatch.getOriginal()).f_19853_.m_46469_().m_46207_(EpicFightGamerules.CAN_SWITCH_COMBAT)) {
            this.playerpatch.toggleMode();
        }
    }

    private void weaponInnateSkillKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode() && this.currentChargingKey != key && !EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
            if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                if (!this.player.m_5833_()) {
                    this.reserveKey(SkillSlots.WEAPON_INNATE, key);
                }
            } else {
                this.lockHotkeys();
            }
        }
    }

    private void moverKeyPressed(KeyMapping key, int action) {
        if (action == 1 && this.playerpatch.isBattleMode() && !this.playerpatch.isChargingSkill()) {
            if (key.getKey().m_84873_() == this.options.f_92089_.getKey().m_84873_()) {
                SkillExecuteEvent event;
                SkillContainer skillContainer = this.playerpatch.getSkill(SkillSlots.MOVER);
                if (skillContainer.canExecute(this.playerpatch, event = new SkillExecuteEvent(this.playerpatch, skillContainer)) && this.player.m_20202_() == null && !this.moverPressToggle) {
                    this.moverPressToggle = true;
                }
            } else {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendExecuteRequest(this.playerpatch, this);
            }
        }
    }

    private void lockonPressed(KeyMapping key, int action) {
        if (action == 1) {
            this.playerpatch.toggleLockOn();
        }
    }

    private void inputTick(Input input) {
        if (this.moverPressToggle) {
            if (!this.isKeyDown(this.options.f_92089_)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.m_20096_()) {
                    input.f_108572_ = true;
                }
            } else if (this.moverPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendExecuteRequest(this.playerpatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                input.f_108572_ = false;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerpatch.getEntityState())) {
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
            this.player.f_108583_ = -1;
            this.player.m_6858_(false);
        }
        if (this.player.m_6084_()) {
            this.playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(this.playerpatch, input));
        }
    }

    private void tick() {
        SkillContainer skill;
        if (EpicFightKeyMappings.SKILL_EDIT.m_90859_() && this.playerpatch.getSkillCapability() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillEditScreen((Player)this.player, this.playerpatch.getSkillCapability()));
        }
        if (EpicFightKeyMappings.CONFIG.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new IngameConfigurationScreen(this.minecraft, null));
        }
        if (this.playerpatch == null || !this.playerpatch.isBattleMode() || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!this.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().equals((Object)EpicFightKeyMappings.ATTACK.getKey())) {
                if (this.weaponInnatePressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                    if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && this.playerpatch.getTarget() == null && !EpicFightMod.CLIENT_INGAME_CONFIG.noMiningInCombat.getValue().booleanValue()) {
                        this.minecraft.m_202354_();
                        this.setKeyBind(EpicFightKeyMappings.ATTACK, true);
                    } else if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillSlots slot;
            SkillSlots skillSlots = slot = !this.player.m_20096_() && !this.player.m_20069_() && this.player.m_20184_().f_82480_ > 0.05 ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
            if (this.playerpatch.getSkill(slot).sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                this.player.m_36334_();
                this.attackLightPressToggle = false;
                this.releaseAllServedKeys();
            } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.options.f_92090_)) {
                SkillSlots skillSlot = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                SkillContainer skill2 = this.playerpatch.getSkill(skillSlot);
                if (skill2.sendExecuteRequest(this.playerpatch, this).shouldReserverKey()) {
                    this.reserveKey(skillSlot, this.options.f_92090_);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentChargingKey != null) {
            skill = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
            Skill skill3 = skill.getSkill();
            if (skill3 instanceof ChargeableSkill) {
                ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill3);
                if (!this.isKeyDown(this.currentChargingKey)) {
                    this.chargeKeyUnpressed = true;
                }
                if (this.chargeKeyUnpressed && this.playerpatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                    if (skill.getSkill() != null) {
                        skill.sendExecuteRequest(this.playerpatch, this);
                    }
                    this.releaseAllServedKeys();
                }
                if (this.playerpatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                skill = this.playerpatch.getSkill(this.reservedOrChargingSkillSlot);
                --this.reserveCounter;
                if (skill.getSkill() != null && skill.sendExecuteRequest(this.playerpatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.playerpatch.getEntityState().inaction() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.f_92056_[i].m_90859_()) {
                }
            }
        }
    }

    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrChargingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    private void releaseAllServedKeys() {
        this.chargeKeyUnpressed = true;
        this.currentChargingKey = null;
        this.reservedOrChargingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setChargingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.chargeKeyUnpressed = false;
        this.currentChargingKey = keyMapping;
        this.reservedOrChargingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return key.m_90857_() || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return key.m_90857_() || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    public void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        for (int i = 0; i < 9; ++i) {
            while (this.options.f_92056_[i].m_90859_()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(Object packet) {
        this.packets.add(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Minecraft.m_91087_().f_91080_ == null) {
                InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(event.getButton());
                InputConstants.Key inputMouse = InputConstants.Type.MOUSE.m_84895_(event.getButton());
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(input)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(inputMouse)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Events.controllEngine.playerpatch != null && Minecraft.m_91087_().f_91080_ == null) {
                InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(event.getKey());
                InputConstants.Key inputMouse = InputConstants.Type.MOUSE.m_84895_(event.getKey());
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(input)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
                for (KeyMapping keybinding : Events.controllEngine.keyHash.lookupAll(inputMouse)) {
                    if (!Events.controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    Events.controllEngine.keyFunctions.get(keybinding).accept(keybinding, event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ != null && Events.controllEngine.playerpatch != null && Events.controllEngine.playerpatch.getEntityState().inaction() && Events.controllEngine.minecraft.f_91080_ == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controllEngine.playerpatch == null) {
                return;
            }
            controllEngine.inputTick(event.getInput());
        }

        @SubscribeEvent
        public static void clientTickEndEvent(TickEvent.ClientTickEvent event) {
            if (Events.controllEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.START) {
                controllEngine.tick();
            } else {
                for (Object packet : Events.controllEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controllEngine.packets.clear();
            }
        }
    }
}

