/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

public class ValueModifier {
    private float adders;
    private float multipliers;
    private float setters;

    public ValueModifier(float adder, float multiplier, float setter) {
        this.adders = adder;
        this.multipliers = multiplier;
        this.setters = setter;
    }

    public void merge(ValueModifier valueCorrector) {
        this.adders += valueCorrector.adders;
        this.multipliers *= valueCorrector.multipliers;
        this.setters += valueCorrector.setters;
    }

    public float getTotalValue(float value) {
        return this.setters == 0.0f ? value * this.multipliers + this.adders : this.setters;
    }

    public String toString() {
        return this.setters == 0.0f ? String.format("%.0f%%", Float.valueOf(this.multipliers * 100.0f)) + (this.adders == 0.0f ? "" : String.format(" + %.1f", Float.valueOf(this.adders))) : String.format("%.0f", Float.valueOf(this.setters));
    }

    public static ValueModifier empty() {
        return new ValueModifier(0.0f, 1.0f, 0.0f);
    }

    public static ValueModifier adder(float arg) {
        return new ValueModifier(arg, 1.0f, 0.0f);
    }

    public static ValueModifier multiplier(float arg) {
        return new ValueModifier(0.0f, arg, 0.0f);
    }

    public static ValueModifier setter(float arg) {
        return new ValueModifier(0.0f, 1.0f, arg);
    }
}

