/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class CubicBezierCurve {
    private static List<Double> MATRIX_CONSTANTS = Lists.newArrayList();

    private static void getBezierEquationCoefficients(List<Double> points, List<Double> aList, List<Double> bList) {
        int idx;
        ArrayList results = Lists.newArrayList();
        int size = points.size();
        results.add(points.get(0) + points.get(1) * 2.0);
        for (int idx2 = 1; idx2 < size - 2; ++idx2) {
            results.add(points.get(idx2) * 4.0 + points.get(idx2 + 1) * 2.0);
        }
        results.add(points.get(size - 2) * 8.0 + points.get(size - 1));
        int storedConstsSize = MATRIX_CONSTANTS.size();
        int coordSize = results.size();
        if (storedConstsSize < coordSize - 1) {
            for (int i = 0; i < coordSize - 1 - storedConstsSize; ++i) {
                double lastConst = MATRIX_CONSTANTS.get(storedConstsSize - 1);
                MATRIX_CONSTANTS.add(1.0 / (4.0 - lastConst));
            }
        }
        ArrayList convertedResults = Lists.newArrayList();
        for (idx = 0; idx < coordSize; ++idx) {
            if (idx == 0) {
                convertedResults.add((Double)results.get(idx) * 0.5);
                continue;
            }
            if (idx == coordSize - 1) {
                convertedResults.add(((Double)results.get(idx) - 2.0 * (Double)convertedResults.get(idx - 1)) * (1.0 / (7.0 - MATRIX_CONSTANTS.get(idx - 1) * 2.0)));
                continue;
            }
            convertedResults.add(((Double)results.get(idx) - (Double)convertedResults.get(idx - 1)) * MATRIX_CONSTANTS.get(idx));
        }
        for (idx = coordSize - 1; idx >= 0; --idx) {
            if (idx == coordSize - 1) {
                aList.add(0, (Double)convertedResults.get(idx));
                continue;
            }
            aList.add(0, (Double)convertedResults.get(idx) - (Double)convertedResults.get(idx + 1) * MATRIX_CONSTANTS.get(idx));
        }
        for (int i = 0; i < coordSize; ++i) {
            if (i == coordSize - 1) {
                bList.add((aList.get(i) + points.get(i + 1)) * 0.5);
                continue;
            }
            bList.add(2.0 * points.get(i + 1) - aList.get(i + 1));
        }
    }

    private static double cubicBezier(double start, double end, double a, double b, double t) {
        return Math.pow(1.0 - t, 3.0) * start + 3.0 * t * Math.pow(1.0 - t, 2.0) * a + 3.0 * t * t * (1.0 - t) * b + t * t * t * end;
    }

    public static List<Vec3> getBezierInterpolatedPoints(List<Vec3> points, int interpolatedResults) {
        return CubicBezierCurve.getBezierInterpolatedPoints(points, 0, points.size() - 1, interpolatedResults);
    }

    public static List<Vec3> getBezierInterpolatedPoints(List<Vec3> points, int sliceBegin, int sliceEnd, int interpolatedResults) {
        if (points.size() < 3) {
            return null;
        }
        sliceBegin = Math.max(sliceBegin, 0);
        sliceEnd = Math.min(sliceEnd, points.size() - 1);
        int size = points.size();
        ArrayList interpolatedPoints = Lists.newArrayList();
        ArrayList x = Lists.newArrayList();
        ArrayList y = Lists.newArrayList();
        ArrayList z = Lists.newArrayList();
        for (int idx = 0; idx < size; ++idx) {
            x.add(points.get((int)idx).f_82479_);
            y.add(points.get((int)idx).f_82480_);
            z.add(points.get((int)idx).f_82481_);
        }
        ArrayList x_a = Lists.newArrayList();
        ArrayList x_b = Lists.newArrayList();
        ArrayList y_a = Lists.newArrayList();
        ArrayList y_b = Lists.newArrayList();
        ArrayList z_a = Lists.newArrayList();
        ArrayList z_b = Lists.newArrayList();
        CubicBezierCurve.getBezierEquationCoefficients(x, x_a, x_b);
        CubicBezierCurve.getBezierEquationCoefficients(y, y_a, y_b);
        CubicBezierCurve.getBezierEquationCoefficients(z, z_a, z_b);
        for (int i = sliceBegin; i < sliceEnd; ++i) {
            if (interpolatedPoints.size() > 0) {
                interpolatedPoints.remove(interpolatedPoints.size() - 1);
            }
            Vec3 start = points.get(i);
            Vec3 end = points.get(i + 1);
            double x_av = (Double)x_a.get(i);
            double x_bv = (Double)x_b.get(i);
            double y_av = (Double)y_a.get(i);
            double y_bv = (Double)y_b.get(i);
            double z_av = (Double)z_a.get(i);
            double z_bv = (Double)z_b.get(i);
            for (int j = 0; j < interpolatedResults + 1; ++j) {
                double t = (double)j / (double)interpolatedResults;
                interpolatedPoints.add(new Vec3(CubicBezierCurve.cubicBezier(start.f_82479_, end.f_82479_, x_av, x_bv, t), CubicBezierCurve.cubicBezier(start.f_82480_, end.f_82480_, y_av, y_bv, t), CubicBezierCurve.cubicBezier(start.f_82481_, end.f_82481_, z_av, z_bv, t)));
            }
        }
        return interpolatedPoints;
    }

    static {
        MATRIX_CONSTANTS.add(0.5);
    }
}

