/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import yesman.epicfight.api.utils.math.Vec3f;

public class ParseUtil {
    public static int[] toIntArray(JsonArray array) {
        ArrayList result = Lists.newArrayList();
        for (JsonElement je : array) {
            result.add(je.getAsInt());
        }
        return ArrayUtils.toPrimitive((Integer[])result.toArray(new Integer[0]));
    }

    public static float[] toFloatArray(JsonArray array) {
        ArrayList result = Lists.newArrayList();
        for (JsonElement je : array) {
            result.add(Float.valueOf(je.getAsFloat()));
        }
        return ArrayUtils.toPrimitive((Float[])result.toArray(new Float[0]));
    }

    public static Vec3f toVector3f(JsonArray array) {
        ArrayList result = Lists.newArrayList();
        for (JsonElement je : array) {
            result.add(Float.valueOf(je.getAsFloat()));
        }
        if (result.size() < 3) {
            throw new IllegalArgumentException("Requires more than 3 elements to convert into 3d vector.");
        }
        return new Vec3f(((Float)result.get(0)).floatValue(), ((Float)result.get(1)).floatValue(), ((Float)result.get(2)).floatValue());
    }

    public static Vec3 toVector3d(JsonArray array) {
        ArrayList result = Lists.newArrayList();
        for (JsonElement je : array) {
            result.add(je.getAsDouble());
        }
        if (result.size() < 3) {
            throw new IllegalArgumentException("Requires more than 3 elements to convert into 3d vector.");
        }
        return new Vec3(((Double)result.get(0)).doubleValue(), ((Double)result.get(1)).doubleValue(), ((Double)result.get(2)).doubleValue());
    }

    public static AttributeModifier toAttributeModifier(CompoundTag tag) {
        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)tag.m_128461_("operation").toUpperCase(Locale.ROOT));
        return new AttributeModifier(UUID.fromString(tag.m_128461_("uuid")), tag.m_128461_("name"), tag.m_128459_("amount"), operation);
    }
}

