/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPFracture;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.level.block.FractureBlock;
import yesman.epicfight.world.level.block.FractureBlockState;

public class LevelUtil {
    private static final Vec3 IMPACT_DIRECTION = new Vec3(0.0, -1.0, 0.0);

    public static void spreadShockwave(Level level, Vec3 center, Vec3 direction, double length, int edgeX, int edgeZ, List<Entity> entityBeingHit) {
        Vec3 edgeOfShockwave = center.m_82549_(direction.m_82541_().m_82490_((double)((float)length)));
        int xFrom = (int)Math.min(Math.floor(center.f_82479_), (double)edgeX);
        int xTo = (int)Math.max(Math.floor(center.f_82479_), (double)edgeX);
        int zFrom = (int)Math.min(Math.floor(center.f_82481_), (double)edgeZ);
        int zTo = (int)Math.max(Math.floor(center.f_82481_), (double)edgeZ);
        ArrayList affectedBlocks = Lists.newArrayList();
        List entitiesInArea = level.f_46443_ ? null : level.m_45933_(null, new AABB((double)xFrom, center.f_82480_ - length, (double)zFrom, (double)xTo, center.f_82480_ + length, (double)zTo));
        double bounceExponentCoef = Math.min(1.0 / (length * length), 0.1);
        for (int k = zFrom; k <= zTo; ++k) {
            for (int l = xFrom; l <= xTo; ++l) {
                Vec2i blockCoord = new Vec2i(l, k);
                if (!LevelUtil.isBlockOverlapLine(blockCoord, center, edgeOfShockwave)) continue;
                affectedBlocks.add(blockCoord);
            }
        }
        affectedBlocks.sort((v1, v2) -> {
            double v2DistSqr;
            double v1DistSqr = Math.pow((double)v1.x - center.f_82479_, 2.0) + Math.pow((double)v1.y - center.f_82481_, 2.0);
            if (v1DistSqr > (v2DistSqr = Math.pow((double)v2.x - center.f_82479_, 2.0) + Math.pow((double)v2.y - center.f_82481_, 2.0))) {
                return 1;
            }
            if (v1DistSqr == v2DistSqr) {
                return 0;
            }
            return -1;
        });
        double y = center.f_82480_;
        for (Vec2i block : affectedBlocks) {
            Vec3 blockCenter;
            Vec3 centerToBlock;
            double distance;
            BlockState aboveState;
            BlockPos bp = new BlockPos((double)block.x, y, (double)block.y);
            BlockState bs = level.m_8055_(bp);
            BlockPos aboveBp = bp.m_7494_();
            if (LevelUtil.canTransferShockWave(level, aboveBp, aboveState = level.m_8055_(aboveBp))) {
                BlockState aboveTwoState;
                BlockPos aboveTwoBp = aboveBp.m_7494_();
                if (LevelUtil.canTransferShockWave(level, aboveTwoBp, aboveTwoState = level.m_8055_(aboveTwoBp))) break;
                y += 1.0;
                bp = aboveBp;
                bs = aboveState;
            } else if (!level.f_46443_ && aboveState.m_60742_((BlockGetter)level, aboveBp, CollisionContext.m_82749_()).m_83281_() && level.m_46469_().m_46207_(GameRules.f_46132_)) {
                level.m_46961_(aboveBp, level.m_46469_().m_46207_(GameRules.f_46136_));
            }
            if (!LevelUtil.canTransferShockWave(level, bp, bs)) {
                BlockState belowState;
                BlockPos belowBp = bp.m_7495_();
                if (!LevelUtil.canTransferShockWave(level, belowBp, belowState = level.m_8055_(belowBp))) break;
                y -= 1.0;
                bp = belowBp;
                bs = belowState;
            }
            if (length < (distance = (centerToBlock = (blockCenter = new Vec3((double)bp.m_123341_() + 0.5, (double)bp.m_123342_(), (double)bp.m_123343_() + 0.5)).m_82546_(center)).m_165924_())) continue;
            if (level.f_46443_) {
                if (!LevelUtil.canTransferShockWave(level, bp, bs) || bs instanceof FractureBlockState) continue;
                Vec3 rotAxis = IMPACT_DIRECTION.m_82537_(centerToBlock).m_82541_();
                Vector3f axis = new Vector3f((float)rotAxis.f_82479_, (float)rotAxis.f_82480_, (float)rotAxis.f_82481_);
                Vector3f translator = new Vector3f(0.0f, Math.max(0.0f, (float)(distance / length) - 0.5f) * 0.5f, 0.0f);
                Quaternion rotator = axis.m_122240_((float)(distance / length) * 15.0f + level.f_46441_.nextFloat() * 10.0f - 5.0f);
                rotator.m_80148_(Vector3f.f_122223_.m_122240_(level.f_46441_.nextFloat() * 15.0f - 7.5f));
                rotator.m_80148_(Vector3f.f_122225_.m_122240_(level.f_46441_.nextFloat() * 40.0f - 20.0f));
                rotator.m_80148_(Vector3f.f_122227_.m_122240_(level.f_46441_.nextFloat() * 15.0f - 7.5f));
                int lifeTime = 30 + level.f_46441_.nextInt((int)length * 80);
                double bouncing = Math.pow(distance, 2.0) * bounceExponentCoef;
                FractureBlockState fractureBlockState = FractureBlock.getDefaultFractureBlockState(null);
                fractureBlockState.setFractureInfo(bp, bs, translator, rotator, bouncing, lifeTime);
                level.m_7731_(bp, (BlockState)fractureBlockState, 0);
                LevelUtil.createParticle(level, bp, bs);
                continue;
            }
            for (Entity entity : entitiesInArea) {
                boolean inSameY;
                boolean bl = inSameY = (double)(bp.m_123342_() + 1) >= entity.m_20186_() && (double)bp.m_123342_() <= entity.m_20186_();
                if (bp.m_123341_() != entity.m_146903_() || !inSameY || bp.m_123343_() != entity.m_146907_() || entityBeingHit.contains(entity)) continue;
                entityBeingHit.add(entity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void createParticle(Level level, BlockPos bp, BlockState bs) {
        for (int i = 0; i < 4; i += level.m_5822_().nextInt(4)) {
            double x = bp.m_123341_() + i % 2;
            double z = bp.m_123343_() + 1 - i % 2;
            TerrainParticle blockParticle = new TerrainParticle((ClientLevel)level, x, (double)(bp.m_123342_() + 1), z, 0.0, 0.0, 0.0, bs, bp);
            blockParticle.m_172260_((Math.random() - 0.5) * 0.3, Math.random() * 0.5, (Math.random() - 0.5) * 0.3);
            blockParticle.m_107257_(10 + new Random().nextInt(60));
            Minecraft mc = Minecraft.m_91087_();
            mc.f_91061_.m_107344_((Particle)blockParticle);
        }
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, false, false, true);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean hurtEntities) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, false, false, hurtEntities);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean noSound, boolean noParticle) {
        return LevelUtil.circleSlamFracture(caster, level, center, radius, noSound, noParticle, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean circleSlamFracture(@Nullable LivingEntity caster, ClientLevel level, Vec3 center, double radius, boolean noSound, boolean noParticle) {
        return LevelUtil.circleSlamFracture(caster, (Level)level, center, radius, noSound, noParticle, true);
    }

    public static boolean circleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius, boolean noSound, boolean noParticle, boolean hurtEntities) {
        BlockState originBlockState;
        Vec3 closestEdge = new Vec3((double)Math.round(center.f_82479_), Math.floor(center.f_82480_), (double)Math.round(center.f_82481_));
        Vec3 centerOfBlock = new Vec3(Math.floor(center.f_82479_) + 0.5, Math.floor(center.f_82480_), Math.floor(center.f_82481_) + 0.5);
        BlockPos blockPos = new BlockPos(center = closestEdge.m_82557_(center) < centerOfBlock.m_82557_(center) ? closestEdge : centerOfBlock);
        if (!LevelUtil.canTransferShockWave(level, blockPos, originBlockState = level.m_8055_(blockPos))) {
            return false;
        }
        radius = Math.max(0.5, radius);
        if (!level.f_46443_) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisChunkWithSelf(new SPFracture(center, radius, noSound, noParticle), level.m_46745_(blockPos));
        }
        int xFrom = (int)Math.floor(center.f_82479_ - radius);
        int xTo = (int)Math.ceil(center.f_82479_ + radius);
        int zFrom = (int)Math.floor(center.f_82481_ - radius);
        int zTo = (int)Math.ceil(center.f_82481_ + radius);
        ArrayList entityBeingHit = Lists.newArrayList();
        for (int i = zFrom; i <= zTo; ++i) {
            for (int j = xFrom; j <= xTo; j += i == zFrom || i == zTo ? 1 : xTo - xFrom) {
                Vec3 direction = new Vec3((double)j - center.f_82479_ + 0.1, 0.0, (double)i - center.f_82481_);
                LevelUtil.spreadShockwave(level, center, direction, radius, j, i, entityBeingHit);
            }
        }
        if (!level.f_46443_ && hurtEntities) {
            for (Entity entity : entityBeingHit) {
                if (entity.m_7306_((Entity)caster)) continue;
                double damageInflict = 1.0 - (entity.m_20182_().m_82554_(center) - radius * 0.5) / radius;
                float damage = (float)(radius * 2.0 * Math.min(damageInflict, 1.0));
                entity.m_6469_(EpicFightDamageSource.commonEntityDamageSource("shockwave", caster, Animations.DUMMY_ANIMATION).setInitialPosition(center).addTag(SourceTags.FINISHER).setStunType(StunType.KNOCKDOWN).cast().m_19375_(), damage);
            }
        } else {
            boolean smallSlam;
            boolean bl = smallSlam = radius < 1.5;
            if (!noSound) {
                level.m_7785_(center.f_82479_, center.f_82480_, center.f_82481_, smallSlam ? EpicFightSounds.GROUND_SLAM_SMALL : EpicFightSounds.GROUND_SLAM, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (!smallSlam && !noParticle) {
                level.m_7106_((ParticleOptions)EpicFightParticles.GROUND_SLAM.get(), center.f_82479_, center.f_82480_, center.f_82481_, 1.0, radius * 10.0, 0.5);
            }
        }
        return true;
    }

    public static boolean canTransferShockWave(Level level, BlockPos blockPos, BlockState blockState) {
        return Block.m_49918_((VoxelShape)blockState.m_60742_((BlockGetter)level, blockPos, CollisionContext.m_82749_()), (Direction)Direction.DOWN) || blockState instanceof FractureBlockState;
    }

    private static boolean isBlockOverlapLine(Vec2i vec2, Vec3 from, Vec3 to) {
        return LevelUtil.isLinesCross(vec2.x, vec2.y, vec2.x + 1, vec2.y, from.f_82479_, from.f_82481_, to.f_82479_, to.f_82481_) || LevelUtil.isLinesCross(vec2.x, vec2.y, vec2.x, vec2.y + 1, from.f_82479_, from.f_82481_, to.f_82479_, to.f_82481_) || LevelUtil.isLinesCross(vec2.x + 1, vec2.y, vec2.x + 1, vec2.y + 1, from.f_82479_, from.f_82481_, to.f_82479_, to.f_82481_) || LevelUtil.isLinesCross(vec2.x, vec2.y + 1, vec2.x + 1, vec2.y + 1, from.f_82479_, from.f_82481_, to.f_82479_, to.f_82481_);
    }

    private static boolean isLinesCross(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double u = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((x2 - x1) * (y4 - y3) - (x4 - x3) * (y2 - y1));
        double v = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((x2 - x1) * (y4 - y3) - (x4 - x3) * (y2 - y1));
        return 0.0 < u && u < 1.0 && 0.0 < v && v < 1.0;
    }
}

