/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HitEntityList {
    private List<Entity> hitEntites;
    private int index = -1;

    public HitEntityList(LivingEntityPatch<?> attacker, List<Entity> entities, Priority priority) {
        this.hitEntites = priority.sort(attacker, entities);
    }

    public Entity getEntity() {
        return this.hitEntites.get(this.index);
    }

    public boolean next() {
        ++this.index;
        return this.hitEntites.size() > this.index;
    }

    public static enum Priority {
        DISTANCE((attacker, list) -> {
            ArrayList distanceToAttacker = Lists.newArrayList();
            ArrayList hitEntites = Lists.newArrayList();
            block0: for (Entity entity : list) {
                int index;
                double distance = ((LivingEntity)attacker.getOriginal()).m_20280_(entity);
                for (index = 0; index < hitEntites.size(); ++index) {
                    if (!(distance < (Double)distanceToAttacker.get(index))) continue;
                    hitEntites.add(index, entity);
                    distanceToAttacker.add(index, distance);
                    continue block0;
                }
                hitEntites.add(index, entity);
                distanceToAttacker.add(index, distance);
            }
            return hitEntites;
        }),
        TARGET((attacker, list) -> {
            ArrayList hitEntites = Lists.newArrayList();
            for (Entity entity : list) {
                if (!entity.m_7306_((Entity)attacker.getTarget())) continue;
                hitEntites.add(entity);
            }
            return hitEntites;
        }),
        HOSTILITY((attacker, list) -> {
            ArrayList firstTargets = Lists.newArrayList();
            ArrayList secondTargets = Lists.newArrayList();
            ArrayList lastTargets = Lists.newArrayList();
            block0: for (Entity e : list) {
                if (attacker.isTeammate(e)) continue;
                if (((LivingEntity)attacker.getOriginal()).m_142581_() == e || attacker.getTarget() == e) {
                    firstTargets.add(e);
                    continue;
                }
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(e, LivingEntityPatch.class);
                if (entitypatch != null && ((LivingEntity)attacker.getOriginal()).m_7306_((Entity)entitypatch.getTarget())) {
                    firstTargets.add(e);
                    continue;
                }
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    if (((LivingEntity)attacker.getOriginal()).m_7306_((Entity)mob.m_5448_())) {
                        firstTargets.add(mob);
                        continue;
                    }
                    GoalSelector targetingAi = mob.f_21346_;
                    for (WrappedGoal goal : targetingAi.m_148105_()) {
                        Goal patt3002$temp = goal.m_26015_();
                        if (!(patt3002$temp instanceof NearestAttackableTargetGoal)) continue;
                        NearestAttackableTargetGoal targetGoal = (NearestAttackableTargetGoal)patt3002$temp;
                        if (!targetGoal.f_26051_.m_26885_((LivingEntity)mob, (LivingEntity)attacker.getOriginal())) continue;
                        secondTargets.add(mob);
                        continue block0;
                    }
                }
                lastTargets.add(e);
            }
            secondTargets.addAll(lastTargets);
            firstTargets.addAll(secondTargets);
            return firstTargets;
        });

        BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction;

        private Priority(BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction) {
            this.sortingFunction = sortingFunction;
        }

        public List<Entity> sort(LivingEntityPatch<?> attacker, List<Entity> entities) {
            return this.sortingFunction.apply(attacker, entities);
        }
    }
}

