/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public class SingleVertex {
    private Vec3f position;
    private Vec3f normal;
    private Vec2f textureCoordinate;
    private Vec3f effectiveJointIDs;
    private Vec3f effectiveJointWeights;
    private int effectiveJointNumber;

    public SingleVertex() {
        this.position = null;
        this.normal = null;
        this.textureCoordinate = null;
    }

    public SingleVertex(SingleVertex vertex) {
        this.position = vertex.position;
        this.effectiveJointIDs = vertex.effectiveJointIDs;
        this.effectiveJointWeights = vertex.effectiveJointWeights;
        this.effectiveJointNumber = vertex.effectiveJointNumber;
    }

    public SingleVertex setPosition(Vec3f position) {
        this.position = position;
        return this;
    }

    public SingleVertex setNormal(Vec3f vector) {
        this.normal = vector;
        return this;
    }

    public SingleVertex setTextureCoordinate(Vec2f vector) {
        this.textureCoordinate = vector;
        return this;
    }

    public SingleVertex setEffectiveJointIDs(Vec3f effectiveJointIDs) {
        this.effectiveJointIDs = effectiveJointIDs;
        return this;
    }

    public SingleVertex setEffectiveJointWeights(Vec3f effectiveJointWeights) {
        this.effectiveJointWeights = effectiveJointWeights;
        return this;
    }

    public SingleVertex setEffectiveJointNumber(int count) {
        this.effectiveJointNumber = count;
        return this;
    }

    public State compareTextureCoordinateAndNormal(Vec3f normal, Vec2f textureCoord) {
        if (this.textureCoordinate == null) {
            return State.EMPTY;
        }
        if (this.textureCoordinate.equals(textureCoord) && this.normal.equals(normal)) {
            return State.EQUAL;
        }
        return State.DIFFERENT;
    }

    public static AnimatedMesh loadVertexInformation(List<SingleVertex> vertices, Map<String, List<Integer>> indices) {
        return SingleVertex.loadVertexInformationWithRenderProperty(vertices, indices, Mesh.RenderProperties.builder());
    }

    public static AnimatedMesh loadVertexInformationWithRenderProperty(List<SingleVertex> vertices, Map<String, List<Integer>> indices, Mesh.RenderProperties.Builder builder) {
        ArrayList positions = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList texCoords = Lists.newArrayList();
        ArrayList animationIndices = Lists.newArrayList();
        ArrayList jointWeights = Lists.newArrayList();
        ArrayList affectCountList = Lists.newArrayList();
        for (int i = 0; i < vertices.size(); ++i) {
            SingleVertex vertex = vertices.get(i);
            Vec3f position = vertex.position;
            Vec3f normal = vertex.normal;
            Vec2f texCoord = vertex.textureCoordinate;
            positions.add(Float.valueOf(position.x));
            positions.add(Float.valueOf(position.y));
            positions.add(Float.valueOf(position.z));
            normals.add(Float.valueOf(normal.x));
            normals.add(Float.valueOf(normal.y));
            normals.add(Float.valueOf(normal.z));
            texCoords.add(Float.valueOf(texCoord.x));
            texCoords.add(Float.valueOf(texCoord.y));
            Vec3f effectIDs = vertex.effectiveJointIDs;
            Vec3f weights = vertex.effectiveJointWeights;
            int count = Math.min(vertex.effectiveJointNumber, 3);
            affectCountList.add(count);
            block6: for (int j = 0; j < count; ++j) {
                switch (j) {
                    case 0: {
                        animationIndices.add((int)effectIDs.x);
                        jointWeights.add(Float.valueOf(weights.x));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 1: {
                        animationIndices.add((int)effectIDs.y);
                        jointWeights.add(Float.valueOf(weights.y));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 2: {
                        animationIndices.add((int)effectIDs.z);
                        jointWeights.add(Float.valueOf(weights.z));
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                }
            }
        }
        float[] positionList = ArrayUtils.toPrimitive((Float[])positions.toArray(new Float[0]));
        float[] normalList = ArrayUtils.toPrimitive((Float[])normals.toArray(new Float[0]));
        float[] texCoordList = ArrayUtils.toPrimitive((Float[])texCoords.toArray(new Float[0]));
        int[] animationIndexList = ArrayUtils.toPrimitive((Integer[])animationIndices.toArray(new Integer[0]));
        float[] jointWeightList = ArrayUtils.toPrimitive((Float[])jointWeights.toArray(new Float[0]));
        int[] affectJointCounts = ArrayUtils.toPrimitive((Integer[])affectCountList.toArray(new Integer[0]));
        HashMap arrayMap = Maps.newHashMap();
        HashMap meshMap = Maps.newHashMap();
        arrayMap.put("positions", positionList);
        arrayMap.put("normals", normalList);
        arrayMap.put("uvs", texCoordList);
        arrayMap.put("weights", jointWeightList);
        for (Map.Entry<String, List<Integer>> e : indices.entrySet()) {
            meshMap.put(e.getKey(), new ModelPart<VertexIndicator.AnimatedVertexIndicator>(VertexIndicator.createAnimated(ArrayUtils.toPrimitive((Integer[])e.getValue().toArray(new Integer[0])), affectJointCounts, animationIndexList)));
        }
        return new AnimatedMesh((Map<String, float[]>)arrayMap, null, builder.build(), meshMap);
    }

    public static enum State {
        EMPTY,
        EQUAL,
        DIFFERENT;

    }
}

