/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.FABRIK;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public interface ProceduralAnimation {
    default public void setIKInfo(IKInfo[] ikInfos, Map<String, TransformSheet> src, Map<String, TransformSheet> dest, Armature armature, boolean correctY, boolean correctZ) {
        for (IKInfo ikInfo : ikInfos) {
            ikInfo.pathToEndJoint = Lists.newArrayList();
            Joint start = armature.searchJointByName(ikInfo.startJoint.getName());
            ikInfo.pathToEndJoint.add(start.getName());
            for (int pathToEnd = Integer.parseInt(start.searchPath(new String(""), ikInfo.endJoint.getName())); pathToEnd > 0; pathToEnd /= 10) {
                start = start.getSubJoints().get(pathToEnd % 10 - 1);
                ikInfo.pathToEndJoint.add(start.getName());
            }
            Keyframe[] keyframes = src.get(ikInfo.endJoint.getName()).getKeyframes();
            Keyframe[] bindedposKeyframes = new Keyframe[keyframes.length];
            int keyframeLength = src.get(ikInfo.endJoint.getName()).getKeyframes().length;
            for (int i = 0; i < keyframeLength; ++i) {
                Keyframe kf = keyframes[i];
                Pose pose = new Pose();
                for (String jointName : src.keySet()) {
                    pose.putJointData(jointName, src.get(jointName).getInterpolatedTransform(kf.time()));
                }
                OpenMatrix4f bindedTransform = armature.getBindedTransformFor(pose, ikInfo.endJoint);
                JointTransform bindedJointTransform = JointTransform.fromMatrixNoScale(bindedTransform);
                bindedposKeyframes[i] = new Keyframe(kf);
                JointTransform tipTransform = bindedposKeyframes[i].transform();
                tipTransform.copyFrom(bindedJointTransform);
                if (!correctY && !correctZ) continue;
                JointTransform rootTransform = src.get("Root").getInterpolatedTransform(kf.time());
                Vec3f rootPos = rootTransform.translation();
                float yCorrection = correctY ? -rootPos.z : 0.0f;
                float zCorrection = correctZ ? rootPos.y : 0.0f;
                tipTransform.translation().add(0.0f, yCorrection, zCorrection);
            }
            TransformSheet tipAnimation = new TransformSheet(bindedposKeyframes);
            dest.put(ikInfo.endJoint.getName(), tipAnimation);
            if (ikInfo.clipAnimation) {
                TransformSheet part = tipAnimation.copy(ikInfo.startFrame, ikInfo.endFrame);
                Keyframe[] partKeyframes = part.getKeyframes();
                ikInfo.startpos = partKeyframes[0].transform().translation();
                ikInfo.endpos = partKeyframes[partKeyframes.length - 1].transform().translation();
            } else {
                ikInfo.endpos = ikInfo.startpos = tipAnimation.getKeyframes()[0].transform().translation();
            }
            ikInfo.startToEnd = Vec3f.sub(ikInfo.endpos, ikInfo.startpos, null).multiply(-1.0f, 1.0f, -1.0f);
        }
    }

    default public TransformSheet getFirstPart(TransformSheet transformSheet) {
        TransformSheet part = transformSheet.copy(0, 2);
        Keyframe[] keyframes = part.getKeyframes();
        keyframes[1].transform().copyFrom(keyframes[0].transform());
        return part;
    }

    default public TransformSheet clipAnimation(TransformSheet transformSheet, IKInfo ikInfo) {
        if (ikInfo.clipAnimation) {
            return transformSheet.copy(ikInfo.startFrame, ikInfo.endFrame);
        }
        return this.getFirstPart(transformSheet);
    }

    default public Vec3f getRayCastedTipPosition(Vec3f clipStart, OpenMatrix4f toWorldCoord, EnderDragonPatch enderdragonpatch, float maxYDown, float leastHeight) {
        Vec3f clipStartWorld = OpenMatrix4f.transform3v(toWorldCoord, clipStart, null);
        BlockHitResult clipResult = ((EnderDragon)enderdragonpatch.getOriginal()).f_19853_.m_45547_(new ClipContext(new Vec3((double)clipStartWorld.x, (double)clipStartWorld.y, (double)clipStartWorld.z), new Vec3((double)clipStartWorld.x, (double)(clipStartWorld.y - maxYDown), (double)clipStartWorld.z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, enderdragonpatch.getOriginal()));
        float dy = clipResult.m_6662_() != HitResult.Type.MISS ? clipStartWorld.y - (float)clipResult.m_82425_().m_123342_() - 1.0f : maxYDown;
        return new Vec3f(clipStartWorld.x, clipStartWorld.y - dy + leastHeight, clipStartWorld.z);
    }

    default public void correctRootRotation(JointTransform rootTransform, EnderDragonPatch enderdragonpatch, float partialTicks) {
        float xRoot = enderdragonpatch.xRootO + (enderdragonpatch.xRoot - enderdragonpatch.xRootO) * partialTicks;
        float zRoot = enderdragonpatch.zRootO + (enderdragonpatch.zRoot - enderdragonpatch.zRootO) * partialTicks;
        Quaternion quat = Vector3f.f_122227_.m_122240_(zRoot);
        quat.m_80148_(Vector3f.f_122223_.m_122240_(-xRoot));
        rootTransform.frontResult(JointTransform.getRotation(quat), OpenMatrix4f::mulAsOriginFront);
    }

    default public void applyFabrikToJoint(Vec3f recalculatedPosition, Pose pose, Armature armature, Joint startJoint, Joint endJoint, Quaternion tipRotation) {
        FABRIK fabrik = new FABRIK(pose, armature, startJoint, endJoint);
        fabrik.run(recalculatedPosition, 10);
        OpenMatrix4f tipRotationMatrix = OpenMatrix4f.fromQuaternion(tipRotation);
        OpenMatrix4f animRotation = armature.getBindedTransformFor(pose, endJoint).removeTranslation();
        OpenMatrix4f animToTipRotation = OpenMatrix4f.mul(OpenMatrix4f.invert(animRotation, null), tipRotationMatrix, null);
        pose.getOrDefaultTransform(endJoint.getName()).overwriteRotation(JointTransform.fromMatrixNoScale(animToTipRotation));
    }

    default public void startPartAnimation(IKInfo ikInfo, TipPointAnimation tipAnim, TransformSheet partAnimation, Vec3f targetpos) {
        Vec3f footpos = tipAnim.getTipPosition(1.0f);
        Vec3f worldStartToEnd = targetpos.copy().sub(footpos);
        partAnimation.correctAnimationByNewPosition(ikInfo.startpos, ikInfo.startToEnd, footpos, worldStartToEnd);
        tipAnim.start(targetpos, partAnimation, 1.0f);
    }

    default public void startSimple(IKInfo ikInfo, TipPointAnimation tipAnim) {
        tipAnim.start(new Vec3f(0.0f, 0.0f, 0.0f), tipAnim.getAnimation(), 1.0f);
    }
}

