/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Function;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.TypeFlexibleHashMap;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SelectiveAnimation
extends StaticAnimation {
    public static final TypeFlexibleHashMap.TypeKey<Integer> PREVIOUS_STATE = new TypeFlexibleHashMap.TypeKey<Integer>(){

        @Override
        public Integer defaultValue() {
            return -1;
        }
    };
    private final Function<LivingEntityPatch<?>, Integer> selector;
    private final StaticAnimation[] animations;

    public SelectiveAnimation(Function<LivingEntityPatch<?>, Integer> selector, StaticAnimation ... animations) {
        super(0.15f, false, "", null);
        this.selector = selector;
        this.animations = animations;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        int result = this.selector.apply(entitypatch);
        ((Animator)entitypatch.getAnimator()).playAnimation(this.animations[result], 0.0f);
        ((Animator)entitypatch.getAnimator()).putAnimationVariables(PREVIOUS_STATE, result);
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        ((Animator)entitypatch.getAnimator()).removeAnimationVariables(PREVIOUS_STATE);
    }

    @Override
    public boolean isMetaAnimation() {
        return true;
    }

    @Override
    public void loadAnimation(ResourceManager resourceManager) {
        for (StaticAnimation anim : this.animations) {
            anim.addEvents(AnimationProperty.StaticAnimationProperty.EVENTS, AnimationEvent.create((entitypatch, animation, params) -> {
                int result = this.selector.apply(entitypatch);
                if (((Animator)entitypatch.getAnimator()).getAnimationVariables(PREVIOUS_STATE) != result) {
                    ((Animator)entitypatch.getAnimator()).playAnimation(this.animations[result], 0.0f);
                    ((Animator)entitypatch.getAnimator()).putAnimationVariables(PREVIOUS_STATE, result);
                }
            }, AnimationEvent.Side.BOTH));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.animations[0].getPriority();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.animations[0].getLayerType();
    }
}

