/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.TypeFlexibleHashMap;

public class EntityState {
    public static final EntityState DEFAULT_STATE = new EntityState(new TypeFlexibleHashMap(true));
    public static final StateFactor<Boolean> TURNING_LOCKED = new StateFactor<Boolean>("turningLocked", false);
    public static final StateFactor<Boolean> MOVEMENT_LOCKED = new StateFactor<Boolean>("movementLocked", false);
    public static final StateFactor<Boolean> ATTACKING = new StateFactor<Boolean>("attacking", false);
    public static final StateFactor<Boolean> CAN_BASIC_ATTACK = new StateFactor<Boolean>("canBasicAttack", true);
    public static final StateFactor<Boolean> CAN_SKILL_EXECUTION = new StateFactor<Boolean>("canExecuteSkill", true);
    public static final StateFactor<Boolean> INACTION = new StateFactor<Boolean>("inaction", false);
    public static final StateFactor<Boolean> KNOCKDOWN = new StateFactor<Boolean>("knockdown", false);
    public static final StateFactor<Boolean> LOCKON_ROTATE = new StateFactor<Boolean>("lockonRotate", false);
    public static final StateFactor<Boolean> UPDATE_LIVING_MOTION = new StateFactor<Boolean>("updateLivingMotion", true);
    public static final StateFactor<Integer> HURT_LEVEL = new StateFactor<Integer>("hurtLevel", 0);
    public static final StateFactor<Integer> PHASE_LEVEL = new StateFactor<Integer>("phaseLevel", 0);
    public static final StateFactor<Function<DamageSource, AttackResult.ResultType>> ATTACK_RESULT = new StateFactor<Function<DamageSource, AttackResult.ResultType>>("attackResultModifier", damagesource -> AttackResult.ResultType.SUCCESS);
    TypeFlexibleHashMap<StateFactor<?>> stateMap;

    public EntityState(TypeFlexibleHashMap<StateFactor<?>> states) {
        this.stateMap = states;
    }

    public <T> void setState(StateFactor<T> stateFactor, T val) {
        this.stateMap.put(stateFactor, val);
    }

    public <T> T getState(StateFactor<T> stateFactor) {
        return this.stateMap.getOrDefault(stateFactor);
    }

    public boolean turningLocked() {
        return this.getState(TURNING_LOCKED);
    }

    public boolean movementLocked() {
        return this.getState(MOVEMENT_LOCKED);
    }

    public boolean attacking() {
        return this.getState(ATTACKING);
    }

    public AttackResult.ResultType attackResult(DamageSource damagesource) {
        return this.getState(ATTACK_RESULT).apply(damagesource);
    }

    public boolean canBasicAttack() {
        return this.getState(CAN_BASIC_ATTACK);
    }

    public boolean canUseSkill() {
        return this.getState(CAN_SKILL_EXECUTION);
    }

    public boolean inaction() {
        return this.getState(INACTION);
    }

    public boolean updateLivingMotion() {
        return this.getState(UPDATE_LIVING_MOTION);
    }

    public boolean hurt() {
        return this.getState(HURT_LEVEL) > 0;
    }

    public int hurtLevel() {
        return this.getState(HURT_LEVEL);
    }

    public boolean knockDown() {
        return this.getState(KNOCKDOWN);
    }

    public boolean lockonRotate() {
        return this.getState(LOCKON_ROTATE);
    }

    public int getLevel() {
        return this.getState(PHASE_LEVEL);
    }

    public static class StateFactor<T>
    implements TypeFlexibleHashMap.TypeKey<T> {
        private String name;
        private T defaultValue;

        public StateFactor(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }
    }
}

