/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.entity.DodgeLeft;

public class DodgeAnimation
extends ActionAnimation {
    public static final Function<DamageSource, AttackResult.ResultType> DODGEABLE_SOURCE_VALIDATOR = damagesource -> {
        if (!(!(damagesource instanceof EntityDamageSource) || damagesource.m_19372_() || damagesource.m_19387_() || damagesource.m_19376_() || damagesource.m_19378_())) {
            return AttackResult.ResultType.MISSED;
        }
        return AttackResult.ResultType.SUCCESS;
    };

    public DodgeAnimation(float convertTime, String path, float width, float height, Armature armature) {
        this(convertTime, 10.0f, path, width, height, armature);
    }

    public DodgeAnimation(float convertTime, float delayTime, String path, float width, float height, Armature armature) {
        super(convertTime, delayTime, path, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, delayTime).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).addState(EntityState.INACTION, true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR);
        this.addProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, Boolean.valueOf(true));
        this.addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, AnimationEvent.create(Animations.ReusableSources.RESTORE_BOUNDING_BOX, AnimationEvent.Side.BOTH));
        this.addEvents(AnimationProperty.StaticAnimationProperty.EVENTS, AnimationEvent.create(Animations.ReusableSources.RESIZE_BOUNDING_BOX, AnimationEvent.Side.BOTH).params(EntityDimensions.m_20395_((float)width, (float)height)));
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && entitypatch != null) {
            ((LivingEntity)entitypatch.getOriginal()).m_183503_().m_7967_((Entity)new DodgeLeft(entitypatch));
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch.isLogicalClient() && entitypatch instanceof LocalPlayerPatch) {
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
            localPlayerPatch.changeModelYRot(0.0f);
        }
    }
}

