/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.property;

import com.mojang.math.Quaternion;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MoveCoordFunctions {
    public static final MoveCoordGetter DIFF_FROM_PREV_COORD = (animation, entitypatch, coord) -> {
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        JointTransform jt = coord.getInterpolatedTransform(player.getElapsedTime());
        JointTransform prevJt = coord.getInterpolatedTransform(player.getPrevElapsedTime());
        Vec4f currentpos = new Vec4f(jt.translation());
        Vec4f prevpos = new Vec4f(prevJt.translation());
        OpenMatrix4f rotationTransform = entitypatch.getModelMatrix(1.0f).removeTranslation();
        OpenMatrix4f localTransform = entitypatch.getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
        rotationTransform.mulBack(localTransform);
        currentpos.transform(rotationTransform);
        prevpos.transform(rotationTransform);
        boolean hasNoGravity = ((LivingEntity)entitypatch.getOriginal()).m_20068_();
        boolean moveVertical = animation.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false || animation.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isPresent();
        float dx = prevpos.x - currentpos.x;
        float dy = moveVertical || hasNoGravity ? currentpos.y - prevpos.y : 0.0f;
        float dz = prevpos.z - currentpos.z;
        dx = Math.abs(dx) > 1.0E-4f ? dx : 0.0f;
        dz = Math.abs(dz) > 1.0E-4f ? dz : 0.0f;
        BlockPos blockpos = new BlockPos(livingentity.m_20185_(), livingentity.m_142469_().f_82289_ - 1.0, livingentity.m_20189_());
        BlockState blockState = livingentity.f_19853_.m_8055_(blockpos);
        AttributeInstance movementSpeed = livingentity.m_21051_(Attributes.f_22279_);
        boolean soulboost = blockState.m_204336_(BlockTags.f_13080_) && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)livingentity) > 0;
        float speedFactor = (float)(soulboost ? 1.0 : (double)livingentity.f_19853_.m_8055_(blockpos).m_60734_().m_49961_());
        float moveMultiplier = (float)(animation.getProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED).orElse(false) != false ? movementSpeed.m_22135_() / movementSpeed.m_22115_() : 1.0);
        return new Vec3f(dx * moveMultiplier * speedFactor, dy, dz * moveMultiplier * speedFactor);
    };
    public static final MoveCoordGetter WORLD_COORD = (animation, entitypatch, coord) -> {
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        JointTransform jt = coord.getInterpolatedTransform(player.getElapsedTime());
        Vec3 entityPos = livingentity.m_20182_();
        return jt.translation().copy().sub(Vec3f.fromDoubleVector(entityPos));
    };
    public static final MoveCoordGetter ATTACHED = (animation, entitypatch, coord) -> {
        LivingEntity target = entitypatch.getGrapplingTarget();
        if (target == null) {
            return DIFF_FROM_PREV_COORD.get(animation, entitypatch, coord);
        }
        TransformSheet rootCoord = animation.getCoord();
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        Vec3f model = rootCoord.getInterpolatedTransform(player.getElapsedTime()).translation();
        Vec3f world = OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(-target.m_146908_(), Vec3f.Y_AXIS), model, null);
        Vec3f dst = Vec3f.fromDoubleVector(target.m_20182_()).add(world);
        livingentity.m_146922_(Mth.m_14177_((float)(target.m_146908_() + 180.0f)));
        return dst.sub(Vec3f.fromDoubleVector(livingentity.m_20182_()));
    };
    public static final MoveCoordSetter TRACE_DEST_LOCATION_BEGIN = (self, entitypatch, transformSheet) -> {
        LivingEntity attackTarget = entitypatch.getTarget();
        TransformSheet transform = self.getCoord().copyAll();
        Keyframe[] rootKeyframes = transform.getKeyframes();
        if (attackTarget != null && attackTarget.m_6084_()) {
            Vec3 start = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            Vec3 toTarget = attackTarget.m_20182_().m_82546_(start);
            Vec3f modelDst = rootKeyframes[rootKeyframes.length - 1].transform().translation().copy().multiply(-1.0f, 1.0f, -1.0f);
            float yRot = (float)MathUtils.getYRotOfVector(toTarget);
            modelDst.rotate(-yRot, Vec3f.Y_AXIS);
            Vec3 dst = attackTarget.m_20182_().m_82520_((double)modelDst.x, (double)modelDst.y, (double)modelDst.z);
            float clampedXRot = MathUtils.rotlerp(((LivingEntity)entitypatch.getOriginal()).m_146909_(), (float)MathUtils.getXRotOfVector(toTarget), 20.0f);
            float clampedYRot = MathUtils.rotlerp(((LivingEntity)entitypatch.getOriginal()).m_146908_(), yRot, entitypatch.getYRotLimit());
            TransformSheet newTransform = transform.getCorrectedWorldCoord(entitypatch, start, dst, -clampedXRot, clampedYRot, 0, rootKeyframes.length);
            transformSheet.readFrom(newTransform);
        } else {
            transform.transform(jt -> {
                Vec3f firstPos = self.getCoord().getKeyframes()[0].transform().translation().copy();
                jt.translation().sub(firstPos);
                LivingEntity original = (LivingEntity)entitypatch.getOriginal();
                Vec3 pos = original.m_20182_();
                jt.translation().rotate(-original.m_146908_(), Vec3f.Y_AXIS);
                jt.translation().multiply(-1.0f, 1.0f, -1.0f);
                jt.translation().add(Vec3f.fromDoubleVector(pos));
            });
            transformSheet.readFrom(transform);
        }
    };
    public static final MoveCoordSetter TRACE_DEST_LOCATION = (self, entitypatch, transformSheet) -> {
        LivingEntity attackTarget = entitypatch.getTarget();
        if (attackTarget != null && attackTarget.m_6084_()) {
            TransformSheet transform = self.getCoord().copyAll();
            Keyframe[] rootKeyframes = transform.getKeyframes();
            Vec3 start = entitypatch.getArmature().getActionAnimationCoord().getKeyframes()[0].transform().translation().toDoubleVector();
            Vec3 toTarget = attackTarget.m_20182_().m_82546_(start);
            Vec3f modelDst = rootKeyframes[rootKeyframes.length - 1].transform().translation().copy().multiply(1.0f, 1.0f, -1.0f);
            float yRot = (float)MathUtils.getYRotOfVector(toTarget);
            modelDst.rotate(-yRot, Vec3f.Y_AXIS);
            Vec3 dst = attackTarget.m_20182_().m_82549_(modelDst.toDoubleVector());
            float clampedXRot = (float)MathUtils.getXRotOfVector(toTarget);
            float clampedYRot = MathUtils.rotlerp(((LivingEntity)entitypatch.getOriginal()).m_146908_(), yRot, entitypatch.getYRotLimit());
            TransformSheet newTransform = transform.getCorrectedWorldCoord(entitypatch, start, dst, -clampedXRot, clampedYRot, 0, rootKeyframes.length);
            ((LivingEntity)entitypatch.getOriginal()).m_146922_(clampedYRot);
            transformSheet.readFrom(newTransform);
        }
    };
    public static final MoveCoordSetter TRACE_LOC_TARGET = (self, entitypatch, transformSheet) -> {
        LivingEntity attackTarget = entitypatch.getTarget();
        if (attackTarget != null && !self.getRealAnimation().getProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue()) {
            TransformSheet transform = self.getCoord().copyAll();
            Keyframe[] keyframes = transform.getKeyframes();
            int startFrame = 0;
            int endFrame = keyframes.length - 1;
            Vec3f keyLast = keyframes[endFrame].transform().translation();
            Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            Vec3 targetpos = attackTarget.m_20182_();
            Vec3 toTarget = targetpos.m_82546_(pos);
            Vec3 viewVec = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
            float horizontalDistance = Math.max((float)toTarget.m_165924_() - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
            Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
            float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
            if (scale > 1.0f) {
                float dot = (float)toTarget.m_82541_().m_82526_(viewVec.m_82541_());
                scale = Math.max(scale * dot, 1.0f);
            }
            for (int i = startFrame; i <= endFrame; ++i) {
                Vec3f translation = keyframes[i].transform().translation();
                if (!(translation.z < 0.0f)) continue;
                translation.z *= scale;
            }
            transformSheet.readFrom(transform);
        } else {
            transformSheet.readFrom(self.getCoord().copyAll());
        }
    };
    public static final MoveCoordSetter TRACE_LOCROT_TARGET = (self, entitypatch, transformSheet) -> {
        LivingEntity attackTarget = entitypatch.getTarget();
        if (attackTarget != null) {
            TransformSheet transform = self.getCoord().copyAll();
            Keyframe[] keyframes = transform.getKeyframes();
            int startFrame = 0;
            int endFrame = keyframes.length - 1;
            Vec3f keyLast = keyframes[endFrame].transform().translation();
            Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            Vec3 targetpos = attackTarget.m_20182_();
            Vec3 toTarget = targetpos.m_82546_(pos);
            float horizontalDistance = Math.max((float)toTarget.m_165924_() - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
            Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
            float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
            float yRot = (float)MathUtils.getYRotOfVector(toTarget);
            float clampedYRot = MathUtils.rotlerp(((LivingEntity)entitypatch.getOriginal()).m_146908_(), yRot, entitypatch.getYRotLimit());
            ((LivingEntity)entitypatch.getOriginal()).m_146922_(clampedYRot);
            for (int i = startFrame; i <= endFrame; ++i) {
                Vec3f translation = keyframes[i].transform().translation();
                if (!(translation.z < 0.0f)) continue;
                translation.z *= scale;
            }
            transformSheet.readFrom(transform);
        } else {
            transformSheet.readFrom(self.getCoord().copyAll());
        }
    };
    public static final MoveCoordSetter RAW_COORD = (self, entitypatch, transformSheet) -> transformSheet.readFrom(self.getCoord().copyAll());
    public static final MoveCoordSetter RAW_COORD_WITH_X_ROT = (self, entitypatch, transformSheet) -> {
        float xRot = ((LivingEntity)entitypatch.getOriginal()).m_146909_();
        TransformSheet sheet = self.getCoord().copyAll();
        for (Keyframe kf : sheet.getKeyframes()) {
            kf.transform().translation().rotate(-xRot, Vec3f.X_AXIS);
        }
        transformSheet.readFrom(sheet);
    };
    public static final MoveCoordSetter VEX_TRACE = (self, entitypatch, transformSheet) -> {
        TransformSheet transform = self.getCoord().copyAll();
        Keyframe[] keyframes = transform.getKeyframes();
        int startFrame = 0;
        int endFrame = 6;
        Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
        Vec3 targetpos = entitypatch.getTarget().m_20182_();
        float verticalDistance = (float)(targetpos.f_82480_ - pos.f_82480_);
        Quaternion rotator = Vec3f.getRotatorBetween(new Vec3f(0.0f, -verticalDistance, (float)targetpos.m_82546_(pos).m_165924_()), new Vec3f(0.0f, 0.0f, 1.0f));
        for (int i = startFrame; i <= endFrame; ++i) {
            Vec3f translation = keyframes[i].transform().translation();
            OpenMatrix4f.transform3v(OpenMatrix4f.fromQuaternion(rotator), translation, translation);
        }
        transformSheet.readFrom(transform);
    };

    @FunctionalInterface
    public static interface MoveCoordGetter {
        public Vec3f get(DynamicAnimation var1, LivingEntityPatch<?> var2, TransformSheet var3);
    }

    @FunctionalInterface
    public static interface MoveCoordSetter {
        public void set(DynamicAnimation var1, LivingEntityPatch<?> var2, TransformSheet var3);
    }
}

