/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.AnimationDataReader;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.main.EpicFightMod;

public class AnimationManager
extends SimplePreparableReloadListener<Map<Integer, Map<Integer, StaticAnimation>>> {
    private final Map<Integer, Map<Integer, StaticAnimation>> animationById = Maps.newHashMap();
    private final Map<ResourceLocation, StaticAnimation> animationByName = Maps.newHashMap();
    private String modid;
    private int namespaceHash;
    private int counter = 0;

    public StaticAnimation findAnimationById(int namespaceId, int animationId) {
        Map<Integer, StaticAnimation> map;
        if (this.animationById.containsKey(namespaceId) && (map = this.animationById.get(namespaceId)).containsKey(animationId)) {
            return map.get(animationId);
        }
        throw new IllegalArgumentException("Unable to find animation. id: " + animationId + ", namespcae hash: " + namespaceId);
    }

    public StaticAnimation findAnimationByPath(String resourceLocation) {
        ResourceLocation rl = new ResourceLocation(resourceLocation);
        if (this.animationByName.containsKey(rl)) {
            return this.animationByName.get(rl);
        }
        throw new IllegalArgumentException("Unable to find animation: " + rl);
    }

    public void registerAnimations() {
        this.animationById.clear();
        this.animationByName.clear();
        HashMap registryMap = Maps.newHashMap();
        ModLoader.get().postEvent((Event)new AnimationRegistryEvent(registryMap));
        registryMap.entrySet().forEach(entry -> {
            this.modid = (String)entry.getKey();
            this.namespaceHash = this.modid.hashCode();
            this.animationById.put(this.namespaceHash, Maps.newHashMap());
            this.counter = 0;
            ((Runnable)entry.getValue()).run();
        });
    }

    public void loadAnimationsOnServer() {
        this.registerAnimations();
        this.animationById.values().forEach(map -> map.values().forEach(animation -> {
            animation.loadAnimation(null);
            this.setAnimationProperties(null, (StaticAnimation)animation);
        }));
    }

    protected Map<Integer, Map<Integer, StaticAnimation>> prepare(ResourceManager resourceManager, ProfilerFiller profilerIn) {
        if (EpicFightMod.isPhysicalClient()) {
            this.registerAnimations();
            this.animationById.values().forEach(map -> map.values().forEach(animation -> this.setAnimationProperties(resourceManager, (StaticAnimation)animation)));
        }
        return this.animationById;
    }

    protected void apply(Map<Integer, Map<Integer, StaticAnimation>> objectIn, ResourceManager resourceManager, ProfilerFiller profilerIn) {
        objectIn.values().forEach(map -> map.values().forEach(animation -> animation.loadAnimation(resourceManager)));
    }

    private void setAnimationProperties(ResourceManager resourceManager, StaticAnimation animation) {
        ResourceLocation dataLocation;
        if (resourceManager == null) {
            return;
        }
        ResourceLocation location = animation.getLocation();
        String path = location.m_135815_();
        int last = location.m_135815_().lastIndexOf(47);
        if (last > 0 && resourceManager.m_7165_(dataLocation = new ResourceLocation(location.m_135827_(), String.format("%s/data%s.json", path.substring(0, last), path.substring(last))))) {
            try {
                AnimationDataReader.readAndApply(animation, resourceManager, resourceManager.m_142591_(dataLocation));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getModid() {
        return this.modid;
    }

    public int getNamespaceHash() {
        return this.namespaceHash;
    }

    public int getIdCounter() {
        return this.counter++;
    }

    public Map<Integer, StaticAnimation> getIdMap() {
        return this.animationById.get(this.namespaceHash);
    }

    public Map<ResourceLocation, StaticAnimation> getNameMap() {
        return this.animationByName;
    }
}

