/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.worldgen.feature.structures.structure;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.worldgen.feature.structures.load.StructureUtils;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class GiantHideoutStructure
extends StructureFeature<JigsawConfiguration> {
    public GiantHideoutStructure() {
        super(JigsawConfiguration.f_67756_, (PieceGeneratorSupplier)new PlacementFactory("giant_hideout"));
    }

    public static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        return !context.f_197352_().m_212265_(BuiltinStructureSets.f_209820_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 1);
    }

    @Nonnull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static class PlacementFactory
    implements PieceGeneratorSupplier<JigsawConfiguration> {
        private final String structureId;

        private PlacementFactory(String structureId) {
            this.structureId = structureId;
        }

        @Nonnull
        public Optional<PieceGenerator<JigsawConfiguration>> m_197347_(@Nonnull PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
            if (!GiantHideoutStructure.isFeatureChunk(context)) {
                return Optional.empty();
            }
            BlockPos centerOfChunk = context.f_197355_().m_151394_(0);
            int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return Optional.empty();
            }
            JigsawConfiguration config = new JigsawConfiguration((Holder)context.f_197360_().m_206191_(Registry.f_122884_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)QuestGiverMod.getInstance().resource(this.structureId))).orElseThrow(() -> new NoSuchElementException("Template not found: " + this.structureId)), 10);
            BlockPos position = context.f_197355_().m_151394_(0);
            return JigsawPlacement.m_210284_(StructureUtils.withConfig(context, config), PoolElementStructurePiece::new, (BlockPos)position, (boolean)false, (boolean)true);
        }
    }
}

