/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.util;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.config.SpawnConfig;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public final class GuildGenUtils {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    public static final HashSet<ResourceLocation> GUILD_STRUCTURES = new HashSet();
    public static final Map<ResourceLocation, Set<ResourceLocation>> VILLAGES_TO_GUILD = new HashMap<ResourceLocation, Set<ResourceLocation>>();

    public static void addToStructurePool(MinecraftServer server, ResourceLocation village, ResourceLocation guild, int weight) {
        Holder emptyProcessorList = server.m_206579_().m_175515_(Registry.f_122883_).m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        Optional poolGetter = server.m_206579_().m_175515_(Registry.f_122884_).m_6612_(village);
        if (poolGetter.isEmpty()) {
            QuestGiverMod.LOGGER.error("Cannot add to " + village + " as it cannot be found!");
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)poolGetter.get();
        List pieceList = pool.f_210560_;
        SinglePoolElement piece = (SinglePoolElement)StructurePoolElement.m_210531_((String)guild.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        ArrayList<Pair> list = new ArrayList<Pair>(pool.f_210559_);
        list.add(Pair.of((Object)piece, (Object)weight));
        pool.f_210559_ = list;
        for (int i = 0; i < weight; ++i) {
            pieceList.add(piece);
        }
    }

    public static void registerVillage(MinecraftServer server, ResourceLocation village, ResourceLocation guild) {
        QuestGiverMod.LOGGER.info("Adding guild " + guild.toString() + " to village " + village.toString());
        GuildGenUtils.addToStructurePool(server, village, guild, 3);
    }

    public static void registerGuildVillageWorldgen(MinecraftServer server) {
        for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : VILLAGES_TO_GUILD.entrySet()) {
            for (ResourceLocation location : entry.getValue()) {
                GuildGenUtils.registerVillage(server, entry.getKey(), location);
            }
        }
    }

    static {
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/desert/houses/guild_house"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/desert/houses/stall"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/plains/houses/guild_house"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/plains/houses/stall"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/savanna/houses/guild_house"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/savanna/houses/stall"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/snow/houses/guild_house"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/snow/houses/stall"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/taiga/houses/guild_house"));
        GUILD_STRUCTURES.add(ResourceLocation.m_135820_((String)"quest_giver:village/taiga/houses/stall"));
        for (Map.Entry<String, Set<String>> entry : SpawnConfig.GuildConfig.add_structure_piece.entrySet()) {
            for (String value : entry.getValue()) {
                Set set = VILLAGES_TO_GUILD.computeIfAbsent(ResourceLocation.m_135820_((String)entry.getKey()), key -> new HashSet());
                set.add(new ResourceLocation(QuestGiverMod.getInstance().modid, value));
            }
        }
    }
}

