/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.screen.widget;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.network.quest.SelectQuestSerializer;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import com.feywild.quest_giver.util.QuestGiverTextProcessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestWidget
extends Button {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 40;
    public int id;
    private QuestNumber questNumber;
    private BlockPos pos;
    private Component title;
    public static final ResourceLocation SELECTION_TEXTURE = new ResourceLocation(QuestGiverMod.getInstance().modid, "textures/gui/quest_background_05.png");
    private final SelectableQuest quest;
    private final ItemStack iconStack;

    public QuestWidget(int x, int y, SelectableQuest quest, Component title, QuestNumber questNumber, BlockPos pos, int id) {
        super(x, y, 160, 40, QuestGiverTextProcessor.INSTANCE.processLine(quest.display.title), b -> {});
        this.title = title;
        this.quest = quest;
        this.iconStack = new ItemStack((ItemLike)quest.icon);
        this.questNumber = questNumber;
        this.pos = pos;
        this.id = id;
    }

    public void m_5691_() {
        super.m_5691_();
        QuestGiverMod.getNetwork().channel.sendToServer((Object)new SelectQuestSerializer.Message(this.quest.id, this.title, this.questNumber, this.pos, this.id));
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SELECTION_TEXTURE);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 0, 160, 40);
        Minecraft.m_91087_().m_91291_().m_115123_(this.iconStack, this.f_93620_ + 8, this.f_93621_ + 10);
        if (this.quest.display.title.m_6111_().length() < 20) {
            String title_string = this.quest.display.title.m_6111_();
            Objects.requireNonNull(font);
            QuestWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)title_string, (int)(this.f_93620_ + 30), (int)(this.f_93621_ + (40 - 9) / 2), (int)0xFFFFFF);
        } else {
            String title_string = this.quest.display.title.m_6111_().substring(0, 20) + "...";
            Objects.requireNonNull(font);
            QuestWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)title_string, (int)(this.f_93620_ + 30), (int)(this.f_93621_ + (40 - 9) / 2), (int)0xFFFFFF);
        }
    }

    public boolean isHovered(int x, int y) {
        return this.f_93620_ <= x && this.f_93620_ + 160 >= x && this.f_93621_ <= y && this.f_93621_ + 40 >= y;
    }
}

