/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.screen;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.events.ClientEvents;
import com.feywild.quest_giver.events.RenderEvents;
import com.feywild.quest_giver.network.quest.ConfirmQuestSerializer;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.screen.button.QuestButton;
import com.feywild.quest_giver.screen.button.QuestButtonSmall;
import com.feywild.quest_giver.screen.widget.BackgroundWidget;
import com.feywild.quest_giver.screen.widget.CharacterWidget;
import com.feywild.quest_giver.util.QuestGiverTextProcessor;
import com.feywild.quest_giver.util.RenderEnum;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.util.ComponentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class DisplayQuestScreen
extends Screen {
    private final QuestDisplay display;
    private final boolean hasConfirmationButtons;
    private List<FormattedCharSequence> description;
    protected List<List<FormattedCharSequence>> textBlocks;
    private List<FormattedCharSequence> currentTextBlock;
    public int textBlockNumber;
    private final QuestNumber questNumber;
    private final BlockPos pos;
    private float xMouse;
    private float yMouse;
    int QUEST_WINDOW_POSITION_Y = 120;
    int QUEST_WINDOW_POSITION_X = 50;
    int ACCEPT_POSITION_Y = 190;
    int ACCEPT_POSITION_X = 380;
    int DECLINE_POSITION_Y = 218;
    int DECLINE_POSITION_X = 380;
    int NEXT_POSITION_Y = 120;
    int NEXT_POSITION_X = 380;
    int CHARACTER_POSITION_Y = 240;
    int CHARACTER_POSITION_X = 37;
    int DESCRIPTION_POSITION_Y = 148;
    int DESCRIPTION_POSITION_X = 70;
    int TITLE_POSITION_Y = 125;
    int WIDTH_SCREEN = 323;
    int animationCount = 0;
    int lineCount = 0;
    int secondAnimationCount = 0;
    int id;

    public DisplayQuestScreen(QuestDisplay display, boolean hasConfirmationButtons, Component name, QuestNumber questNumber, BlockPos pos, int id) {
        super(name);
        this.display = display;
        this.hasConfirmationButtons = hasConfirmationButtons;
        this.questNumber = questNumber;
        this.pos = pos;
        this.id = id;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new BackgroundWidget(this, this.QUEST_WINDOW_POSITION_X, this.QUEST_WINDOW_POSITION_Y));
        this.m_142416_((GuiEventListener)new CharacterWidget(this, this.CHARACTER_POSITION_X, this.CHARACTER_POSITION_Y, (LivingEntity)this.f_96541_.f_91073_.m_6815_(this.id)));
        this.description = QuestGiverTextProcessor.INSTANCE.process(this.display.description).stream().flatMap(line -> ComponentRenderUtils.m_94005_((FormattedText)line, (int)280, (Font)Minecraft.m_91087_().f_91062_).stream()).collect(Collectors.toList());
        this.textBlocks = this.getTextBlocks(this.description, 8);
        this.textBlockNumber = 0;
        this.currentTextBlock = this.textBlocks.get(this.textBlockNumber);
        if (this.textBlocks.size() > 1) {
            this.m_142416_((GuiEventListener)new QuestButtonSmall(this.NEXT_POSITION_X, this.NEXT_POSITION_Y, true, this.pos, (Component)new TextComponent(">>"), button -> {
                ++this.textBlockNumber;
                this.reset();
                if (this.textBlockNumber == this.textBlocks.size() - 1) {
                    button.m_93666_((Component)new TextComponent("x"));
                }
                if (this.textBlockNumber < this.textBlocks.size()) {
                    this.currentTextBlock = this.textBlocks.get(this.textBlockNumber);
                } else {
                    this.m_7379_();
                }
            }));
        }
        if (this.hasConfirmationButtons) {
            TranslatableComponent msg1 = this.getRandomAcceptMessage();
            this.m_142416_((GuiEventListener)new QuestButton(this.ACCEPT_POSITION_X, this.ACCEPT_POSITION_Y, true, this.pos, (Component)msg1, button -> {
                QuestGiverMod.getNetwork().channel.sendToServer((Object)new ConfirmQuestSerializer.Message(true, this.questNumber, RenderEnum.QUESTION));
                RenderEvents.renders.put(this.questNumber.id, RenderEnum.QUESTION);
                this.m_7379_();
            }));
            TranslatableComponent msg2 = this.getRandomDeclineMessage();
            this.m_142416_((GuiEventListener)new QuestButton(this.DECLINE_POSITION_X, this.DECLINE_POSITION_Y, false, this.pos, (Component)msg2, button -> {
                QuestGiverMod.getNetwork().channel.sendToServer((Object)new ConfirmQuestSerializer.Message(false, this.questNumber, RenderEnum.EXCLAMATION));
                RenderEvents.renders.put(this.questNumber.id, RenderEnum.EXCLAMATION);
                this.m_7379_();
            }));
        }
        ClientEvents.setShowGui(false);
    }

    private TranslatableComponent getRandomAcceptMessage() {
        Random random = new Random();
        return switch (random.nextInt(5)) {
            case 1 -> new TranslatableComponent("text.quest_giver.accept1");
            case 2 -> new TranslatableComponent("text.quest_giver.accept2");
            case 3 -> new TranslatableComponent("text.quest_giver.accept3");
            case 4 -> new TranslatableComponent("text.quest_giver.accept4");
            default -> new TranslatableComponent("text.quest_giver.accept5");
        };
    }

    private TranslatableComponent getRandomDeclineMessage() {
        Random random = new Random();
        return switch (random.nextInt(5)) {
            case 1 -> new TranslatableComponent("text.quest_giver.decline1");
            case 2 -> new TranslatableComponent("text.quest_giver.decline2");
            case 3 -> new TranslatableComponent("text.quest_giver.decline3");
            case 4 -> new TranslatableComponent("text.quest_giver.decline4");
            default -> new TranslatableComponent("text.quest_giver.decline5");
        };
    }

    public void m_7379_() {
        ClientEvents.setShowGui(true);
        this.currentTextBlock = this.textBlocks.get(0);
        this.reset();
        super.m_7379_();
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.drawTextLines(poseStack, mouseX, mouseY);
    }

    private void drawTextLines(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_96541_ != null) {
            DisplayQuestScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.f_96539_, (int)(this.QUEST_WINDOW_POSITION_X + this.WIDTH_SCREEN / 2 - this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_) / 2), (int)this.TITLE_POSITION_Y, (int)0xFFFFFF);
            if (this.lineCount < this.getCurrentTextBlock().size()) {
                for (int i = 0; i < this.lineCount + 1; ++i) {
                    int x = 0;
                    if (i != 0) {
                        Font font = this.f_96541_.f_91062_;
                        float f = this.DESCRIPTION_POSITION_X;
                        Objects.requireNonNull(this.f_96541_.f_91062_);
                        font.m_92744_(poseStack, this.getCurrentTextBlock().get(i - 1), f, (float)(this.DESCRIPTION_POSITION_Y + (2 + 9) * (i - 1)), 0xFFFFFF);
                    }
                    for (int j = 0; j < this.secondAnimationCount; ++j) {
                        Font font = this.f_96541_.f_91062_;
                        FormattedCharSequence formattedCharSequence = ComponentUtil.subSequence((FormattedCharSequence)this.getCurrentTextBlock().get(i), (int)j, (int)(j + 1));
                        float f = this.DESCRIPTION_POSITION_X + x;
                        Objects.requireNonNull(this.f_96541_.f_91062_);
                        font.m_92744_(poseStack, formattedCharSequence, f, (float)(this.DESCRIPTION_POSITION_Y + (2 + 9) * i), 0xFFFFFF);
                        x += this.f_96541_.f_91062_.m_92724_(ComponentUtil.subSequence((FormattedCharSequence)this.getCurrentTextBlock().get(i), (int)j, (int)(j + 1)));
                    }
                }
                if (this.animationCount != 0) {
                    ++this.animationCount;
                } else {
                    if (this.secondAnimationCount < 60) {
                        ++this.secondAnimationCount;
                    } else {
                        if (this.lineCount < this.getCurrentTextBlock().size()) {
                            ++this.lineCount;
                        }
                        this.secondAnimationCount = 0;
                    }
                    this.animationCount = 0;
                }
            } else {
                for (int i = 0; i < this.getCurrentTextBlock().size(); ++i) {
                    Font font = this.f_96541_.f_91062_;
                    float f = this.DESCRIPTION_POSITION_X;
                    Objects.requireNonNull(this.f_96541_.f_91062_);
                    font.m_92744_(poseStack, this.getCurrentTextBlock().get(i), f, (float)(this.DESCRIPTION_POSITION_Y + (2 + 9) * i), 0xFFFFFF);
                }
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return !this.hasConfirmationButtons;
    }

    public List<List<FormattedCharSequence>> getTextBlocks(List<FormattedCharSequence> description, int numberOfMaxTextBlocks) {
        int nextInc;
        ArrayList<List<FormattedCharSequence>> textBlocks = new ArrayList<List<FormattedCharSequence>>();
        for (int i = 0; i < description.size(); i += nextInc) {
            nextInc = Math.min(description.size() - i, numberOfMaxTextBlocks);
            List<FormattedCharSequence> textBlock = description.subList(i, i + nextInc);
            textBlocks.add(textBlock);
        }
        return textBlocks;
    }

    public List<FormattedCharSequence> getCurrentTextBlock() {
        return this.currentTextBlock;
    }

    public void setCurrentTextBlock(List<FormattedCharSequence> currentTextBlock) {
        this.currentTextBlock = currentTextBlock;
    }

    public void reset() {
        this.lineCount = 0;
        this.animationCount = 0;
        this.secondAnimationCount = 0;
    }
}

