/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.task;

import com.feywild.quest_giver.quest.task.TaskType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.resources.ResourceLocation;

public class TaskTypes {
    private static final BiMap<ResourceLocation, TaskType<?, ?>> values = HashBiMap.create();

    public static TaskType<?, ?> getType(ResourceLocation id) {
        if (values.containsKey((Object)id)) {
            return (TaskType)values.get((Object)id);
        }
        throw new IllegalStateException("Unknown quest task type: " + id);
    }

    public static ResourceLocation getId(TaskType<?, ?> type) {
        if (values.containsValue(type)) {
            return (ResourceLocation)values.inverse().get(type);
        }
        throw new IllegalStateException("Quest task type not registered: " + type);
    }

    public static void register(ResourceLocation id, TaskType<?, ?> type) {
        if (values.containsKey((Object)id)) {
            throw new IllegalStateException("Task type with the same id already registered: " + id);
        }
        if (values.containsValue(type)) {
            throw new IllegalStateException("Task type registered twice: " + type);
        }
        values.put((Object)id, type);
    }
}

