/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.task;

import com.feywild.quest_giver.quest.task.TaskType;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.ITag;

public abstract class TaggableTaskType<T extends IForgeRegistryEntry<T>, X>
implements TaskType<Taggable<T>, X> {
    private final IForgeRegistry<T> registry;
    private final String key;

    protected TaggableTaskType(String key, IForgeRegistry<T> registry) {
        this.key = key;
        this.registry = registry;
    }

    @Override
    public Class<Taggable<T>> element() {
        return Taggable.class;
    }

    @Override
    public Taggable<T> fromJson(JsonObject json) {
        IForgeRegistryEntry entry;
        String value = json.get(this.key).getAsString();
        if (value.startsWith("#")) {
            ResourceLocation location = ResourceLocation.m_135820_((String)value.substring(1));
            if (location != null) {
                return new Taggable<T>(Objects.requireNonNull(Objects.requireNonNull(this.registry).tags()).createTagKey(location), this.registry);
            }
            return null;
        }
        ResourceLocation location = ResourceLocation.m_135820_((String)value);
        if (location != null && (entry = this.registry.getValue(location)) != null) {
            return new Taggable<IForgeRegistryEntry>(entry);
        }
        return null;
    }

    @Override
    public JsonObject toJson(Taggable<T> element) {
        JsonObject json = new JsonObject();
        if (element.tag.isPresent()) {
            json.addProperty(this.key, "#" + element.tag.get().getKey().f_203868_());
        } else {
            json.addProperty(this.key, Objects.requireNonNull(((IForgeRegistryEntry)element.value.orElseThrow()).getRegistryName()).toString());
        }
        return json;
    }

    record Taggable<T extends IForgeRegistryEntry<T>>(Optional<T> value, Optional<ITag<T>> tag) implements Predicate<T>
    {
        public Taggable(T value) {
            this(Optional.of(value), Optional.empty());
        }

        public Taggable(TagKey<T> tagKey, IForgeRegistry<T> registriy) {
            this(Optional.empty(), Optional.of(Objects.requireNonNull(registriy.tags()).getTag(tagKey)));
        }

        @Override
        public boolean test(T input) {
            return this.tag.map(it -> it.contains(input)).orElseGet(() -> ((IForgeRegistryEntry)this.value.orElseThrow()).equals(input));
        }
    }
}

