/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.task;

import com.feywild.quest_giver.quest.task.TaskType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.crafting.IngredientStack;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemStackTask
implements TaskType<IngredientStack, ItemStack> {
    public static final ItemStackTask INSTANCE = new ItemStackTask();

    private ItemStackTask() {
    }

    @Override
    public Class<IngredientStack> element() {
        return IngredientStack.class;
    }

    @Override
    public Class<ItemStack> testType() {
        return ItemStack.class;
    }

    @Override
    public boolean checkCompleted(ServerPlayer player, IngredientStack element, ItemStack match) {
        return element.test(match);
    }

    @Override
    public IngredientStack fromJson(JsonObject json) {
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("item"));
        int amount = json.has("amount") ? json.get("amount").getAsInt() : 1;
        return new IngredientStack(ingredient, amount);
    }

    @Override
    public JsonObject toJson(IngredientStack element) {
        JsonObject json = new JsonObject();
        json.add("item", element.ingredient().m_43942_());
        json.addProperty("amount", (Number)element.count());
        return json;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    @Nullable
    public Item icon(IngredientStack element) {
        ItemStack[] matching = element.ingredient().m_43908_();
        if (matching.length == 1 && !matching[0].m_41619_()) {
            return matching[0].m_41720_();
        }
        return null;
    }
}

