/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.reward;

import com.feywild.quest_giver.quest.reward.RewardType;
import com.feywild.quest_giver.quest.util.GainReputationAction;
import com.google.gson.JsonObject;
import java.util.Collection;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ReputationReward
implements RewardType<GainReputationAction> {
    public static final ReputationReward INSTANCE = new ReputationReward();

    private ReputationReward() {
    }

    @Override
    public Class<GainReputationAction> element() {
        return GainReputationAction.class;
    }

    @Override
    public void grantReward(ServerPlayer player, GainReputationAction element) {
        Collection factions = ReputationHandler.getEntityFactions((LivingEntity)player);
        for (Faction faction : factions) {
            if (!faction.getName().equals(element.getFaction())) continue;
            ReputationHandler.changeReputation((Player)player, (Faction)faction, (int)element.getReputation());
        }
    }

    @Override
    public GainReputationAction fromJson(JsonObject json) {
        String loc = json.get("faction").getAsString();
        int reputation = json.get("reputation").getAsInt();
        return new GainReputationAction(loc, (Integer)reputation);
    }

    @Override
    public JsonObject toJson(GainReputationAction element) {
        JsonObject json = new JsonObject();
        json.addProperty("reputation", (Number)element.getReputation());
        json.addProperty("faction", element.getFactionPath());
        return json;
    }
}

