/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.player;

import com.feywild.quest_giver.quest.Quest;
import com.feywild.quest_giver.quest.QuestLine;
import com.feywild.quest_giver.quest.task.TaskType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class QuestProgress {
    public final ResourceLocation quest;
    private final Map<Integer, Integer> taskProgress = new HashMap<Integer, Integer>();

    public QuestProgress(ResourceLocation quest) {
        this.quest = quest;
    }

    @Nullable
    public <T> String checkComplete(ServerPlayer player, QuestLine quests2, TaskType<?, T> type, T element) {
        String progressMsg = null;
        Quest quest = quests2.getQuest(this.quest);
        if (quest != null) {
            for (int i = 0; i < quest.tasks.size(); ++i) {
                if (!quest.tasks.get(i).checkCompleted(player, type, element)) continue;
                this.taskProgress.putIfAbsent(i, 0);
                this.taskProgress.computeIfPresent(i, (idx, value) -> value + 1);
                if (progressMsg != null) continue;
                progressMsg = this.taskProgress.get(i) + " / " + quest.tasks.get((int)i).times;
            }
        }
        return progressMsg;
    }

    public <T> Stream<T> getQuestElements(ServerPlayer player, QuestLine quests2, TaskType<T, ?> type) {
        Quest quest = quests2.getQuest(this.quest);
        if (quest != null) {
            return quest.tasks.stream().flatMap(task -> task.getQuestValueFor(type).stream());
        }
        return Stream.empty();
    }

    public boolean valid(QuestLine quests2) {
        return quests2.getQuest(this.quest) != null;
    }

    public boolean shouldBeComplete(QuestLine quests2) {
        Quest quest = quests2.getQuest(this.quest);
        if (quest != null) {
            for (int i = 0; i < quest.tasks.size(); ++i) {
                int completionTimes = this.taskProgress.getOrDefault(i, 0);
                if (completionTimes >= quest.tasks.get((int)i).times) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Integer, Integer> entry : this.taskProgress.entrySet()) {
            nbt.m_128405_(Integer.toString(entry.getKey()), entry.getValue().intValue());
        }
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.taskProgress.clear();
        for (String key : nbt.m_128431_()) {
            try {
                int task = Integer.parseInt(key);
                this.taskProgress.put(task, nbt.m_128451_(key));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

