/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.player;

import com.feywild.quest_giver.EventListener;
import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.events.QuestCompletionEvent;
import com.feywild.quest_giver.quest.Quest;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestLine;
import com.feywild.quest_giver.quest.QuestManager;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.QuestReward;
import com.feywild.quest_giver.quest.player.CompletableTaskInfo;
import com.feywild.quest_giver.quest.player.QuestProgress;
import com.feywild.quest_giver.quest.task.TaskType;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import com.feywild.quest_giver.util.RenderEnum;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class QuestLineData {
    private final List<ResourceLocation> pendingCompletion = new ArrayList<ResourceLocation>();
    private final Set<ResourceLocation> completedQuests = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, QuestProgress> activeQuests = new HashMap<ResourceLocation, QuestProgress>();
    @Nullable
    private ServerPlayer player;
    public final QuestNumber questNumber;
    private int reputation;
    private boolean approved = false;
    private RenderEnum icon;

    public QuestLineData(QuestNumber questNumber) {
        this.questNumber = questNumber;
        this.icon = RenderEnum.EXCLAMATION;
    }

    public void attach(ServerPlayer player) {
        this.player = player;
        this.startNextQuests();
        this.icon = RenderEnum.EXCLAMATION;
    }

    public RenderEnum getRender() {
        return this.icon;
    }

    public void setRender(String id) {
        this.icon = RenderEnum.getRender(id);
    }

    public boolean checkForEnd() {
        QuestLine quests2 = this.getQuestLine();
        boolean hasEmptyQuests = false;
        if (quests2 != null) {
            System.out.println(this.getCompletedQuests().size());
            System.out.println(quests2.getQuestCount());
            if (this.getCompletedQuests().size() == quests2.getQuestCount()) {
                hasEmptyQuests = true;
            }
        }
        return hasEmptyQuests;
    }

    public void approve() {
        Quest rootQuest;
        this.approved = true;
        this.reputation = 0;
        this.pendingCompletion.clear();
        this.completedQuests.clear();
        this.activeQuests.clear();
        QuestLine quests2 = QuestManager.getQuests(this.questNumber);
        Quest quest = rootQuest = quests2 == null ? null : quests2.getQuest(new ResourceLocation(QuestGiverMod.getInstance().modid, "root"));
        if (rootQuest != null && rootQuest.tasks.isEmpty()) {
            for (QuestReward reward : rootQuest.rewards) {
                reward.grantReward(this.player);
            }
            this.reputation += rootQuest.reputation;
            this.completedQuests.add(rootQuest.id);
        }
        this.startNextQuests();
    }

    @Nullable
    public QuestLine getQuestLine() {
        return this.questNumber == null ? null : QuestManager.getQuests(this.questNumber);
    }

    public Map<ResourceLocation, QuestProgress> getActiveQuests() {
        return this.activeQuests;
    }

    public Set<ResourceLocation> getCompletedQuests() {
        return this.completedQuests;
    }

    public int getReputation() {
        return this.questNumber == null ? 0 : this.reputation;
    }

    @Nullable
    public QuestDisplay getActiveQuestDisplay(ResourceLocation id) {
        QuestLine quests2 = this.getQuestLine();
        if (quests2 != null && this.player != null && this.activeQuests.containsKey(id)) {
            Quest quest = quests2.getQuest(id);
            if (quest != null) {
                return quest.start;
            }
            return null;
        }
        return null;
    }

    public List<SelectableQuest> getQuests() {
        QuestLine quests2 = this.getQuestLine();
        if (quests2 != null && this.player != null) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (QuestProgress progress : this.activeQuests.values().stream().sorted(Comparator.comparing(q -> q.quest)).toList()) {
                Quest quest = quests2.getQuest(progress.quest);
                if (quest == null) continue;
                list.add((Object)new SelectableQuest(quest.id, quest.icon, quest.start));
            }
            return list.build();
        }
        return ImmutableList.of();
    }

    @Nullable
    public QuestDisplay completePendingQuest() {
        QuestLine quests2 = this.getQuestLine();
        if (quests2 != null && this.player != null && !this.pendingCompletion.isEmpty()) {
            while (!this.pendingCompletion.isEmpty()) {
                ResourceLocation id = this.pendingCompletion.remove(0);
                QuestDisplay display = this.tryComplete(this.player, quests2, id);
                if (display == null) continue;
                return display;
            }
        }
        return null;
    }

    @Nullable
    private QuestDisplay tryComplete(ServerPlayer player, QuestLine quests2, ResourceLocation id) {
        Quest quest = quests2.getQuest(id);
        if (quest != null) {
            QuestDisplay display;
            QuestDisplay questDisplay = display = quest.tasks.isEmpty() ? quest.start : quest.complete;
            if (display != null) {
                for (QuestReward reward : quest.rewards) {
                    reward.grantReward(player);
                }
                this.reputation += quest.reputation;
                MinecraftForge.EVENT_BUS.post((Event)new QuestCompletionEvent(player, quest, this.reputation));
                return display;
            }
            return null;
        }
        return null;
    }

    public boolean hasCompleted(Quest quest) {
        return this.completedQuests.contains(quest.id);
    }

    public <T> boolean checkComplete(TaskType<?, T> type, T element) {
        boolean success = false;
        QuestLine quests2 = this.getQuestLine();
        if (quests2 != null && this.player != null) {
            String msgToDisplay = null;
            for (QuestProgress progress : this.activeQuests.values()) {
                String progressMsg = progress.checkComplete(this.player, quests2, type, element);
                if (progressMsg == null) continue;
                success = true;
                if (msgToDisplay != null) continue;
                msgToDisplay = progressMsg;
            }
            if (success) {
                this.triggerAfterComplete(quests2, msgToDisplay);
            }
        }
        return success;
    }

    public <T, X> List<CompletableTaskInfo<T, X>> getAllCurrentTasks(TaskType<T, X> type) {
        Iterator<QuestProgress> iterator;
        ImmutableList.Builder list = ImmutableList.builder();
        QuestLine quests2 = this.getQuestLine();
        if (quests2 != null && this.player != null && (iterator = this.activeQuests.values().iterator()).hasNext()) {
            QuestProgress progress = iterator.next();
            return progress.getQuestElements(this.player, quests2, type).map(elem -> new CompletableTaskInfo<Object, Object>(type, elem, element -> {
                String progressMsg = progress.checkComplete(this.player, quests2, type, element);
                if (progressMsg != null) {
                    this.triggerAfterComplete(quests2, progressMsg);
                }
            })).toList();
        }
        return list.build();
    }

    private void triggerAfterComplete(QuestLine quests2, String msgToDisplay) {
        boolean shouldNotify = false;
        Iterator<QuestProgress> itr = this.activeQuests.values().iterator();
        while (itr.hasNext()) {
            QuestProgress progress = itr.next();
            if (!progress.shouldBeComplete(quests2)) continue;
            this.pendingCompletion.add(progress.quest);
            this.completedQuests.add(progress.quest);
            shouldNotify = true;
            itr.remove();
        }
        if (this.player != null) {
            if (shouldNotify) {
                this.player.m_5661_((Component)new TranslatableComponent("message.quest_giver.quest_completion"), true);
            } else {
                this.player.m_5661_((Component)new TextComponent(msgToDisplay), true);
            }
        }
        this.startNextQuests();
    }

    public void startNextQuests() {
        QuestLine quests2 = this.getQuestLine();
        boolean hasEmptyQuests = false;
        if (quests2 != null) {
            for (Quest newQuest : quests2.getNextQuests(this.activeQuests.keySet(), this.completedQuests)) {
                if (newQuest.tasks.isEmpty()) {
                    if (this.pendingCompletion.contains(newQuest.id)) continue;
                    this.pendingCompletion.add(newQuest.id);
                    this.completedQuests.add(newQuest.id);
                    hasEmptyQuests = true;
                    continue;
                }
                if (this.activeQuests.containsKey(newQuest.id)) continue;
                QuestProgress progress = new QuestProgress(newQuest.id);
                this.activeQuests.put(newQuest.id, progress);
            }
        }
        if (hasEmptyQuests) {
            this.startNextQuests();
        }
        if (this.player.f_8906_ != null) {
            EventListener.syncPlayerRenders(this.player);
        }
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("QuestNumber", QuestNumber.optionId(this.questNumber));
        nbt.m_128405_("Reputation", this.reputation);
        nbt.m_128379_("Approved", this.approved);
        ListTag pending = new ListTag();
        for (ResourceLocation resourceLocation : this.pendingCompletion) {
            pending.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbt.m_128365_("Pending", (Tag)pending);
        ListTag completed = new ListTag();
        for (ResourceLocation quest : this.completedQuests) {
            completed.add((Object)StringTag.m_129297_((String)quest.toString()));
        }
        nbt.m_128365_("Completed", (Tag)completed);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, QuestProgress> entry : this.activeQuests.entrySet()) {
            compoundTag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().write());
        }
        nbt.m_128365_("Active", (Tag)compoundTag);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.reputation = nbt.m_128451_("Reputation");
        this.approved = nbt.m_128471_("Approved");
        ListTag pending = nbt.m_128437_("Pending", 8);
        this.pendingCompletion.clear();
        for (int i = 0; i < pending.size(); ++i) {
            ResourceLocation id = ResourceLocation.m_135820_((String)pending.m_128778_(i));
            if (id == null) continue;
            this.pendingCompletion.add(id);
        }
        ListTag completed = nbt.m_128437_("Completed", 8);
        this.completedQuests.clear();
        for (int i = 0; i < completed.size(); ++i) {
            ResourceLocation id = ResourceLocation.m_135820_((String)completed.m_128778_(i));
            if (id == null) continue;
            this.completedQuests.add(id);
        }
        CompoundTag active = nbt.m_128469_("Active");
        this.activeQuests.clear();
        for (String key : active.m_128431_()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)key);
            if (id == null) continue;
            QuestProgress progress = new QuestProgress(id);
            progress.read(active.m_128469_(key));
            this.activeQuests.put(id, progress);
        }
    }
}

