/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest.player;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.quest.Quest;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestLine;
import com.feywild.quest_giver.quest.QuestManager;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.player.CapabilityQuests;
import com.feywild.quest_giver.quest.player.CompletableTaskInfo;
import com.feywild.quest_giver.quest.player.QuestLineData;
import com.feywild.quest_giver.quest.task.TaskType;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class QuestData {
    private final Map<QuestNumber, QuestLineData> questLines = new HashMap<QuestNumber, QuestLineData>();
    @Nullable
    private ServerPlayer player;

    public static QuestData get(ServerPlayer player) {
        return (QuestData)player.getCapability(CapabilityQuests.QUESTS).orElseGet(() -> {
            QuestGiverMod.LOGGER.warn("Quest Data capability not present on player: " + player);
            return new QuestData();
        });
    }

    public void attach(ServerPlayer player) {
        this.player = player;
        this.questLines.values().forEach(l -> l.attach(player));
    }

    public boolean canComplete(QuestNumber questNumber) {
        return this.questLines.containsKey((Object)questNumber);
    }

    @Nullable
    public QuestDisplay initialize(QuestNumber questNumber) {
        if (!this.questLines.containsKey((Object)questNumber)) {
            Quest rootQuest;
            QuestLine quests2 = QuestManager.getQuests(questNumber);
            Quest quest = rootQuest = quests2 == null ? null : quests2.getQuest(new ResourceLocation(QuestGiverMod.getInstance().modid, "root"));
            if (rootQuest != null) {
                QuestLineData qld = new QuestLineData(questNumber);
                if (this.player != null) {
                    qld.attach(this.player);
                }
                this.questLines.put(questNumber, qld);
                return rootQuest.start;
            }
            return null;
        }
        return null;
    }

    public void acceptQuestNumber(QuestNumber questNumber) {
        if (this.questLines.containsKey((Object)questNumber)) {
            this.questLines.get((Object)questNumber).approve();
        }
    }

    public void denyQuest(QuestNumber questNumber) {
        this.questLines.remove((Object)questNumber);
    }

    public void reset() {
        this.questLines.clear();
    }

    @Nullable
    public QuestLineData getQuestLine(QuestNumber questNumber) {
        return this.questLines.getOrDefault((Object)questNumber, null);
    }

    public Map<QuestNumber, QuestLineData> getAllQuestLines() {
        return this.questLines;
    }

    public <T> boolean checkComplete(TaskType<?, T> type, T element) {
        boolean success = false;
        for (QuestLineData line : this.questLines.values()) {
            if (!line.checkComplete(type, element)) continue;
            success = true;
        }
        return success;
    }

    public <T, X> List<CompletableTaskInfo<T, X>> getAllCurrentTasks(TaskType<T, X> type) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (QuestLineData line : this.questLines.values()) {
            list.addAll(line.getAllCurrentTasks(type));
        }
        return list.build();
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<QuestNumber, QuestLineData> entry : this.questLines.entrySet()) {
            if (entry.getKey() == null) continue;
            nbt.m_128365_(entry.getKey().id, (Tag)entry.getValue().write());
        }
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.questLines.clear();
        for (String id : nbt.m_128431_()) {
            QuestNumber questNumber = QuestNumber.byOptionId(id);
            if (id == null) continue;
            QuestLineData qld = new QuestLineData(questNumber);
            qld.read(nbt.m_128469_(id));
            if (this.player != null) {
                qld.attach(this.player);
            }
            this.questLines.put(questNumber, qld);
        }
    }
}

