/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest;

import com.feywild.quest_giver.quest.Quest;
import com.feywild.quest_giver.quest.QuestLine;
import com.feywild.quest_giver.quest.QuestNumber;
import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.datapack.DataLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class QuestManager {
    private static Map<QuestNumber, QuestLine> questLines = ImmutableMap.of();

    public static QuestLine getQuests(QuestNumber questNumber) {
        return questLines.getOrDefault((Object)questNumber, QuestLine.EMPTY);
    }

    public static PreparableReloadListener createReloadListener() {
        return new SimplePreparableReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
                return null;
            }

            protected void apply(@Nonnull Void value, @Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
                EnumMap<QuestNumber, QuestLine> lines = new EnumMap<QuestNumber, QuestLine>(QuestNumber.class);
                for (QuestNumber questNumber : QuestNumber.values()) {
                    try {
                        lines.put(questNumber, new QuestLine(DataLoader.loadJson((ResourceManager)rm, (String)("quests/" + questNumber.id), Quest::fromJson)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                questLines = Collections.unmodifiableMap(lines);
            }
        };
    }
}

