/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.quest;

import com.feywild.quest_giver.quest.Quest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class QuestLine {
    public static final QuestLine EMPTY = new QuestLine((Map<ResourceLocation, Quest>)ImmutableMap.of());
    private final Map<ResourceLocation, Quest> quests;
    private final Map<Quest, List<Quest>> questOrder;

    public QuestLine(Map<ResourceLocation, Quest> quests2) {
        this.quests = ImmutableMap.copyOf(quests2);
        ImmutableMap.Builder questOrder = ImmutableMap.builder();
        for (Quest quest : this.quests.values()) {
            questOrder.put((Object)quest, (Object)((List)quest.parents.stream().map(rl -> {
                if (this.quests.containsKey(rl)) {
                    return this.quests.get(rl);
                }
                throw new IllegalStateException("Invalid reference in quest: " + rl);
            }).collect(ImmutableList.toImmutableList())));
        }
        this.questOrder = questOrder.build();
    }

    @Nullable
    public Quest getQuest(ResourceLocation id) {
        return this.quests.getOrDefault(id, null);
    }

    public Set<Quest> getNextQuests(Set<ResourceLocation> active, Set<ResourceLocation> completed) {
        return this.questOrder.entrySet().stream().filter(entry -> !active.contains(((Quest)entry.getKey()).id)).filter(entry -> ((Quest)entry.getKey()).repeatable || !completed.contains(((Quest)entry.getKey()).id)).filter(entry -> ((List)entry.getValue()).stream().allMatch(quest -> completed.contains(quest.id))).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int getQuestCount() {
        return this.quests.size();
    }
}

