/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.network.quest;

import com.feywild.quest_giver.events.RenderEvents;
import com.feywild.quest_giver.util.RenderEnum;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncRenders {
    private final String s;

    public SyncRenders(FriendlyByteBuf buf) {
        this.s = (String)buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8);
    }

    public SyncRenders(String renders) {
        this.s = renders;
    }

    public static void encode(SyncRenders packet, FriendlyByteBuf buf) {
        buf.writeCharSequence((CharSequence)packet.s, StandardCharsets.UTF_8);
    }

    public static void handle(SyncRenders packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {});
        RenderEvents.renders = packet.getRenders();
        ctx.setPacketHandled(true);
    }

    public HashMap<String, RenderEnum> getRenders() {
        String[] pairs;
        if (this.s == null || this.s.isBlank() || this.s.isEmpty()) {
            return new HashMap<String, RenderEnum>();
        }
        HashMap<String, RenderEnum> builtMap = new HashMap<String, RenderEnum>();
        for (String pair : pairs = SyncRenders.stringBreaker(this.s, "%")) {
            String[] broken = SyncRenders.stringBreaker(pair, ",");
            builtMap.put(broken[0], RenderEnum.getRender(broken[1]));
        }
        return builtMap;
    }

    public static String[] stringBreaker(String s, String regex) {
        return s.split(regex);
    }
}

