/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.network.quest;

import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class OpenQuestSelectionSerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, FriendlyByteBuf buffer) {
        buffer.m_130083_(msg.title);
        buffer.m_130068_((Enum)msg.questNumber);
        buffer.m_130064_(msg.pos);
        buffer.m_130130_(msg.quests.size());
        for (SelectableQuest quest : msg.quests) {
            quest.toNetwork(buffer);
        }
        buffer.writeInt(msg.id);
    }

    public Message decode(FriendlyByteBuf buffer) {
        Component title = buffer.m_130238_();
        QuestNumber questNumber = (QuestNumber)buffer.m_130066_(QuestNumber.class);
        BlockPos pos = buffer.m_130135_();
        int questSize = buffer.m_130242_();
        ImmutableList.Builder quests2 = ImmutableList.builder();
        for (int i = 0; i < questSize; ++i) {
            quests2.add((Object)SelectableQuest.fromNetwork(buffer));
        }
        int id = buffer.readInt();
        return new Message(title, questNumber, (List<SelectableQuest>)quests2.build(), pos, id);
    }

    public static class Message {
        public final Component title;
        public final QuestNumber questNumber;
        public final List<SelectableQuest> quests;
        public final BlockPos pos;
        public final int id;

        public Message(Component title, QuestNumber questNumber, List<SelectableQuest> quests2, BlockPos pos, int id) {
            this.title = title;
            this.questNumber = questNumber;
            this.quests = ImmutableList.copyOf(quests2);
            this.pos = pos;
            this.id = id;
        }
    }
}

