/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.network.quest;

import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestNumber;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class OpenQuestDisplaySerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.id);
        buffer.m_130083_(msg.title);
        msg.display.toNetwork(buffer);
        buffer.m_130064_(msg.pos);
        buffer.writeBoolean(msg.confirmationButtons);
        buffer.m_130068_((Enum)msg.questNumber);
    }

    public Message decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        Component title = buffer.m_130238_();
        QuestDisplay display = QuestDisplay.fromNetwork(buffer);
        BlockPos pos = buffer.m_130135_();
        boolean confirmationButtons = buffer.readBoolean();
        QuestNumber questNumber = (QuestNumber)buffer.m_130066_(QuestNumber.class);
        return new Message(display, confirmationButtons, title, questNumber, pos, id);
    }

    public static class Message {
        public final Component title;
        public final QuestDisplay display;
        public final boolean confirmationButtons;
        public final QuestNumber questNumber;
        public final BlockPos pos;
        public final int id;

        public Message(QuestDisplay display, boolean confirmationButtons, Component title, QuestNumber questNumber, BlockPos pos, int id) {
            this.display = display;
            this.confirmationButtons = confirmationButtons;
            this.title = title;
            this.questNumber = questNumber;
            this.pos = pos;
            this.id = id;
        }
    }
}

