/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.network;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.network.quest.ConfirmQuestHandler;
import com.feywild.quest_giver.network.quest.ConfirmQuestSerializer;
import com.feywild.quest_giver.network.quest.OpenQuestDisplayHandler;
import com.feywild.quest_giver.network.quest.OpenQuestDisplaySerializer;
import com.feywild.quest_giver.network.quest.OpenQuestSelectionHandler;
import com.feywild.quest_giver.network.quest.OpenQuestSelectionSerializer;
import com.feywild.quest_giver.network.quest.PlaySoundHandler;
import com.feywild.quest_giver.network.quest.PlaySoundSerializer;
import com.feywild.quest_giver.network.quest.SelectQuestHandler;
import com.feywild.quest_giver.network.quest.SelectQuestSerializer;
import com.feywild.quest_giver.network.quest.SyncPlayerGuiStatus;
import com.feywild.quest_giver.network.quest.SyncRenders;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class QuestGiverNetwork
extends NetworkX {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel BETTER_NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(QuestGiverMod.getInstance().modid, "better_network")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
    public static int disc = 0;

    public QuestGiverNetwork(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"1");
    }

    protected void registerPackets() {
        this.register(new OpenQuestSelectionSerializer(), () -> OpenQuestSelectionHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new OpenQuestDisplaySerializer(), () -> OpenQuestDisplayHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new SelectQuestSerializer(), () -> SelectQuestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new ConfirmQuestSerializer(), () -> ConfirmQuestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new PlaySoundSerializer(), () -> PlaySoundHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        BETTER_NETWORK.registerMessage(disc++, SyncRenders.class, SyncRenders::encode, SyncRenders::new, SyncRenders::handle);
        BETTER_NETWORK.registerMessage(disc++, SyncPlayerGuiStatus.class, SyncPlayerGuiStatus::encode, SyncPlayerGuiStatus::new, SyncPlayerGuiStatus::handle);
    }

    public void sendTo(Object message, ServerPlayer player) {
        BETTER_NETWORK.sendTo(message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToServer(Object message) {
        BETTER_NETWORK.sendToServer(message);
    }
}

