/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.item;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.network.quest.PlaySoundSerializer;
import com.feywild.quest_giver.util.QuestGiverPlayerData;
import com.feywild.quest_giver.util.TooltipHelper;
import io.github.noeppi_noeppi.libx.base.ItemBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraftforge.network.PacketDistributor;

public class TradingContract
extends ItemBase {
    private final String profession;

    public TradingContract(ModX mod, Item.Properties properties, String profession) {
        super(mod, properties);
        this.profession = profession;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos clickedPos = context.m_8083_();
        if (player != null) {
            if (context.m_43725_().m_8055_(clickedPos).m_60734_() instanceof LecternBlock && !context.m_43725_().f_46443_) {
                if (!this.isSignedByPlayer(player)) {
                    QuestGiverPlayerData.get(player).m_128379_(this.profession, true);
                    player.m_6352_((Component)new TranslatableComponent("message.quest_giver.trading_contract_sign"), player.m_142081_());
                    player.m_21011_(hand, true);
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlaySoundSerializer.Message(SoundEvents.f_12493_.m_11660_()));
                } else {
                    player.m_6352_((Component)new TranslatableComponent("message.quest_giver.trading_contract_signed"), player.m_142081_());
                }
            }
            return InteractionResult.m_19078_((boolean)Objects.requireNonNull(player).f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (level != null) {
            TooltipHelper.addTooltip(tooltip, level, new Component[]{new TranslatableComponent("message.quest_giver.trading_contract")});
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean isSignedByPlayer(Player player) {
        return QuestGiverPlayerData.get(player).m_128471_(this.profession);
    }

    public String getProfession() {
        return this.profession;
    }
}

