/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.events;

import com.feywild.quest_giver.entity.GuildMasterProfession;
import com.feywild.quest_giver.entity.QuestGuardVillager;
import com.feywild.quest_giver.entity.QuestVillager;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.util.RenderEnum;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    public static HashMap<String, RenderEnum> renders;
    private static final float ICON_SCALE = 1.0f;
    private static final double MAX_DISTANCE = 64.0;
    private static final double FADE_PERCENTAGE = 50.0;
    private static final int Y_POS = -18;
    private static final int X_POS = -8;

    @SubscribeEvent
    public static void onRenderNamePlate(RenderNameplateEvent event) {
        Villager villager;
        QuestVillager questVillager;
        Entity entity = event.getEntity();
        if (entity instanceof QuestVillager && (questVillager = (QuestVillager)entity).m_7141_().m_35571_() != VillagerProfession.f_35585_ || entity instanceof Villager && (villager = (Villager)entity).m_7141_().m_35571_() == GuildMasterProfession.GUILDMASTER.get() || entity instanceof QuestGuardVillager) {
            Villager villager2;
            RenderEnum icon = RenderEnum.NONE;
            if (entity instanceof QuestVillager) {
                QuestVillager questVillager2 = (QuestVillager)entity;
                if (renders.containsKey(questVillager2.getQuestNumber().id.toLowerCase(Locale.ROOT))) {
                    icon = renders.get(questVillager2.getQuestNumber().id.toLowerCase(Locale.ROOT));
                }
            }
            if (entity instanceof QuestGuardVillager) {
                QuestGuardVillager guard = (QuestGuardVillager)entity;
                if (renders.containsKey(guard.getQuestNumber().id.toLowerCase(Locale.ROOT))) {
                    icon = renders.get(guard.getQuestNumber().id.toLowerCase(Locale.ROOT));
                }
            }
            if (entity instanceof Villager && (villager2 = (Villager)entity).m_7141_().m_35571_() == GuildMasterProfession.GUILDMASTER.get()) {
                icon = renders.get(QuestNumber.QUEST_0014.id.toLowerCase(Locale.ROOT));
            }
            if (icon != RenderEnum.NONE) {
                EntityRenderer renderer = event.getEntityRenderer();
                PoseStack poseStack = event.getPoseStack();
                double squareDistance = renderer.f_114476_.m_114471_(entity);
                double fadeDistance = 32.0;
                double opacityDistance = Mth.m_14008_((double)(1.0 - (Math.sqrt(squareDistance) - fadeDistance) / (64.0 - fadeDistance)), (double)0.0, (double)1.0);
                float markerHeight = entity.m_20206_() + 0.5f;
                if (squareDistance > 4096.0) {
                    return;
                }
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, (double)markerHeight, 0.0);
                poseStack.m_85845_(renderer.f_114476_.m_114470_());
                poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69482_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)opacityDistance));
                RenderEvents.renderMarker(icon.getRender(), poseStack);
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                poseStack.m_85849_();
            }
        }
    }

    private static void renderMarker(ResourceLocation resource, PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        RenderEvents.renderIcon(resource, poseStack);
        poseStack.m_85849_();
    }

    private static void renderIcon(ResourceLocation resource, PoseStack poseStack) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Minecraft.m_91087_().m_91097_().m_118506_(resource).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, -8.0f, -2.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, -2.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, -18.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, -8.0f, -18.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }
}

