/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.entity;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.config.QuestConfig;
import com.feywild.quest_giver.entity.GuildMasterProfession;
import com.feywild.quest_giver.item.TradingContract;
import com.feywild.quest_giver.network.quest.OpenQuestDisplaySerializer;
import com.feywild.quest_giver.network.quest.OpenQuestSelectionSerializer;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.player.QuestData;
import com.feywild.quest_giver.quest.player.QuestLineData;
import com.feywild.quest_giver.quest.task.GiftTask;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import com.samebutdifferent.morevillagers.init.ModProfessions;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class QuestVillager
extends Villager {
    public static final EntityDataAccessor<Integer> QUEST_NUMBER = SynchedEntityData.m_135353_(QuestVillager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean setQuestNumber = false;
    private UUID questTaker;

    public QuestVillager(EntityType<? extends Villager> villager, Level level) {
        super(villager, level);
        this.f_19811_ = true;
    }

    public static boolean canSpawn(EntityType<? extends QuestVillager> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_144274_).contains((Object)level.m_8055_(pos.m_7495_()).m_60734_()) || Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13029_).contains((Object)level.m_8055_(pos.m_7495_()).m_60734_());
    }

    public UUID getQuestTaker() {
        return this.questTaker;
    }

    public void setQuestTaker(Player player) {
        this.questTaker = player.m_142081_();
    }

    public Player getPlayer() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.questTaker);
    }

    public void m_8119_() {
        super.m_8119_();
        VillagerProfession villagerprofession = this.m_7141_().m_35571_();
        if (villagerprofession != VillagerProfession.f_35585_ && !this.setQuestNumber) {
            Random random = new Random();
            if (villagerprofession == VillagerProfession.f_35586_) {
                this.setQuestNumber(QuestConfig.quests.armorer_quests.get(random.nextInt(QuestConfig.quests.armorer_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35587_) {
                this.setQuestNumber(QuestConfig.quests.butcher_quests.get(random.nextInt(QuestConfig.quests.butcher_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35588_) {
                this.setQuestNumber(QuestConfig.quests.cartographer_quests.get(random.nextInt(QuestConfig.quests.cartographer_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35589_) {
                this.setQuestNumber(QuestConfig.quests.cleric_quests.get(random.nextInt(QuestConfig.quests.cleric_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35590_) {
                this.setQuestNumber(QuestConfig.quests.farmer_quests.get(random.nextInt(QuestConfig.quests.farmer_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35591_) {
                this.setQuestNumber(QuestConfig.quests.fisherman_quests.get(random.nextInt(QuestConfig.quests.fisherman_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35592_) {
                this.setQuestNumber(QuestConfig.quests.fletcher_quests.get(random.nextInt(QuestConfig.quests.fletcher_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35593_) {
                this.setQuestNumber(QuestConfig.quests.leatherworker_quests.get(random.nextInt(QuestConfig.quests.leatherworker_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35594_) {
                this.setQuestNumber(QuestConfig.quests.librarian_quests.get(random.nextInt(QuestConfig.quests.librarian_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35595_) {
                this.setQuestNumber(QuestConfig.quests.mason_quests.get(random.nextInt(QuestConfig.quests.mason_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35597_) {
                this.setQuestNumber(QuestConfig.quests.shepherd_quests.get(random.nextInt(QuestConfig.quests.shepherd_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35598_) {
                this.setQuestNumber(QuestConfig.quests.toolsmith_quests.get(random.nextInt(QuestConfig.quests.toolsmith_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == VillagerProfession.f_35599_) {
                this.setQuestNumber(QuestConfig.quests.weaponsmith_quests.get(random.nextInt(QuestConfig.quests.weaponsmith_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == GuildMasterProfession.GUILDMASTER.get()) {
                this.setQuestNumber(QuestConfig.quests.guildmaster_quests.get(random.nextInt(QuestConfig.quests.guildmaster_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.ENDERIAN.get()) {
                this.setQuestNumber(QuestConfig.quests.enderian_quests.get(random.nextInt(QuestConfig.quests.enderian_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.ENGINEER.get()) {
                this.setQuestNumber(QuestConfig.quests.engineer_quests.get(random.nextInt(QuestConfig.quests.engineer_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.FLORIST.get()) {
                this.setQuestNumber(QuestConfig.quests.florist_quests.get(random.nextInt(QuestConfig.quests.florist_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.HUNTER.get()) {
                this.setQuestNumber(QuestConfig.quests.hunter_quests.get(random.nextInt(QuestConfig.quests.hunter_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.MINER.get()) {
                this.setQuestNumber(QuestConfig.quests.miner_quests.get(random.nextInt(QuestConfig.quests.miner_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.NETHERIAN.get()) {
                this.setQuestNumber(QuestConfig.quests.netherian_quests.get(random.nextInt(QuestConfig.quests.netherian_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.OCEANOGRAPHER.get()) {
                this.setQuestNumber(QuestConfig.quests.oceanographer_quests.get(random.nextInt(QuestConfig.quests.oceanographer_quests.size())));
                this.m_35546_(1);
            }
            if (villagerprofession == ModProfessions.WOODWORKER.get()) {
                this.setQuestNumber(QuestConfig.quests.woodworker_quests.get(random.nextInt(QuestConfig.quests.woodworker_quests.size())));
                this.m_35546_(1);
            }
        }
    }

    @NotNull
    public static AttributeSupplier.Builder m_35503_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    public QuestNumber getQuestNumber() {
        if (this.m_7141_().m_35571_() != VillagerProfession.f_35585_) {
            try {
                return QuestNumber.values()[(Integer)this.f_19804_.m_135370_(QUEST_NUMBER)];
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return QuestNumber.values()[0];
            }
        }
        return null;
    }

    public void setQuestNumber(Integer questNumber) {
        this.f_19804_.m_135381_(QUEST_NUMBER, (Object)questNumber);
        this.setQuestNumber = true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUEST_NUMBER, (Object)QUEST_NUMBER.m_135015_());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("QuestNumber", ((Integer)this.f_19804_.m_135370_(QUEST_NUMBER)).intValue());
        if (this.questTaker != null) {
            compound.m_128362_("QuestTaker", this.questTaker);
        }
        compound.m_128379_("SetQuestNumber", this.setQuestNumber);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("QuestNumber")) {
            this.f_19804_.m_135381_(QUEST_NUMBER, (Object)compound.m_128451_("QuestNumber"));
        }
        if (compound.m_128441_("QuestTaker")) {
            this.questTaker = this.serializeNBT().m_128403_("QuestTaker") ? compound.m_128342_("QuestTaker") : null;
        }
        this.setQuestNumber = compound.m_128471_("SetQuestNumber");
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            return super.m_6071_(player, hand);
        }
        if (player instanceof ServerPlayer) {
            if (QuestVillager.tryAcceptGift((ServerPlayer)player, hand, this.getQuestNumber())) {
                player.m_21011_(hand, true);
            } else {
                TradingContract contract;
                Object object;
                if (stack.m_41619_() && ReputationHandler.getReputation((Player)player, (Faction)ReputationHandler.getFaction((ResourceLocation)ResourceLocation.m_135820_((String)"reputation:villager"))) >= 0) {
                    PlayerPatch playerPatch = (PlayerPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (!playerPatch.isBattleMode()) {
                        this.interactQuest((ServerPlayer)player, hand);
                        this.m_7189_(player);
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("message.quest_giver.punch_locals"), player.m_142081_());
                    }
                }
                if ((object = stack.m_41720_()) instanceof TradingContract && Objects.equals((contract = (TradingContract)((Object)object)).getProfession(), this.m_7141_().m_35571_().m_150028_()) && contract.isSignedByPlayer(player)) {
                    for (MerchantOffer merchantoffer : this.m_6616_()) {
                        merchantoffer.m_45353_(-Mth.m_14143_((float)(40.0f * merchantoffer.m_45378_())));
                    }
                    this.m_35536_(player);
                } else {
                    this.m_5496_(SoundEvents.f_12507_, 1.0f, this.m_6100_());
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    private void interactQuest(ServerPlayer player, InteractionHand hand) {
        Component name;
        QuestData quests2 = QuestData.get(player);
        Component component = name = this.m_8077_() ? this.m_7770_() : this.m_5446_();
        if (this.getQuestNumber() != null) {
            if (quests2.canComplete(this.getQuestNumber())) {
                QuestDisplay completionDisplay = Objects.requireNonNull(quests2.getQuestLine(this.getQuestNumber())).completePendingQuest();
                if (this.getQuestTaker() == null) {
                    this.setQuestTaker((Player)player);
                }
                if (completionDisplay != null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(completionDisplay, false, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                    player.m_21011_(hand, true);
                    this.playRandomVillagerSound();
                } else {
                    List<SelectableQuest> active = Objects.requireNonNull(quests2.getQuestLine(this.getQuestNumber())).getQuests();
                    if (active.size() == 1) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(active.get((int)0).display, false, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                        player.m_21011_(hand, true);
                        this.playRandomVillagerSound();
                    } else if (!active.isEmpty()) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestSelectionSerializer.Message(name, this.getQuestNumber(), active, this.m_142538_(), this.m_142049_()));
                        player.m_21011_(hand, true);
                        this.playRandomVillagerSound();
                    } else {
                        this.m_35319_(40);
                        if (!this.f_19853_.m_5776_()) {
                            this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                        }
                    }
                }
            } else {
                QuestDisplay initDisplay = quests2.initialize(this.getQuestNumber());
                if (initDisplay != null && this.getQuestTaker() == null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(initDisplay, true, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                    player.m_21011_(hand, true);
                    this.playRandomVillagerSound();
                } else {
                    this.m_35319_(40);
                    if (!this.f_19853_.m_5776_()) {
                        this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                    }
                }
            }
        } else {
            this.m_35319_(40);
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public static boolean tryAcceptGift(ServerPlayer player, InteractionHand hand, QuestNumber number) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            QuestLineData questLine = QuestData.get(player).getQuestLine(number);
            if (questLine != null && questLine.checkComplete(GiftTask.INSTANCE, stack)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_6352_((Component)new TranslatableComponent("message.quest_giver.accept_gift", new Object[]{player.m_7755_().m_6111_()}), player.m_142081_());
                return true;
            }
            for (QuestLineData data : QuestData.get(player).getAllQuestLines().values()) {
                if (!data.checkComplete(GiftTask.INSTANCE, stack)) continue;
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_6352_((Component)new TranslatableComponent("message.quest_giver.accept_gift", new Object[]{player.m_7755_().m_6111_()}), player.m_142081_());
                return true;
            }
        }
        return false;
    }

    protected boolean m_7341_(@NotNull Entity entity) {
        return false;
    }

    protected void playRandomVillagerSound() {
        switch (this.f_19796_.nextInt(6)) {
            case 2: {
                this.m_5496_(SoundEvents.f_12508_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 3: {
                this.m_5496_(SoundEvents.f_12577_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 4: {
                this.m_5496_(SoundEvents.f_12509_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 5: {
                this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                break;
            }
            default: {
                this.m_5496_(SoundEvents.f_12503_, this.m_6121_(), this.m_6100_());
            }
        }
    }
}

