/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver.entity;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.config.QuestConfig;
import com.feywild.quest_giver.entity.QuestVillager;
import com.feywild.quest_giver.entity.goals.QuestGuardInteractWithPlayerGoal;
import com.feywild.quest_giver.network.quest.OpenQuestDisplaySerializer;
import com.feywild.quest_giver.network.quest.OpenQuestSelectionSerializer;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.player.QuestData;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.ArmorerRepairGuardArmorGoal;
import tallestegg.guardvillagers.entities.ai.goals.FollowShieldGuards;
import tallestegg.guardvillagers.entities.ai.goals.GuardEatFoodGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardRunToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardSetRunningToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtByTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.KickGoal;
import tallestegg.guardvillagers.entities.ai.goals.RaiseShieldGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedBowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedCrossbowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RunToClericGoal;
import tallestegg.guardvillagers.entities.ai.goals.WalkBackToCheckPointGoal;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class QuestGuardVillager
extends Guard {
    public static final EntityDataAccessor<Integer> QUEST_NUMBER = SynchedEntityData.m_135353_(QuestGuardVillager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean setQuestNumber = false;
    private boolean isInteracting = false;
    private Player recentInteractingPlayer = null;

    public QuestGuardVillager(EntityType<? extends Guard> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public static boolean canSpawn(EntityType<? extends QuestGuardVillager> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_144274_).contains((Object)level.m_8055_(pos.m_7495_()).m_60734_()) || Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13029_).contains((Object)level.m_8055_(pos.m_7495_()).m_60734_());
    }

    public QuestNumber getQuestNumber() {
        try {
            return QuestNumber.values()[(Integer)this.f_19804_.m_135370_(QUEST_NUMBER)];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return QuestNumber.values()[0];
        }
    }

    public void setQuestNumber(Integer questNumber) {
        this.f_19804_.m_135381_(QUEST_NUMBER, (Object)questNumber);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new KickGoal((Guard)this));
        this.f_21345_.m_25352_(0, (Goal)new GuardEatFoodGoal((Guard)this));
        this.f_21345_.m_25352_(0, (Goal)new RaiseShieldGoal((Guard)this));
        this.f_21345_.m_25352_(1, (Goal)new QuestGuardInteractWithPlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GuardRunToEatGoal((Guard)this));
        this.f_21345_.m_25352_(2, (Goal)new GuardSetRunningToEatGoal((Guard)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RangedCrossbowAttackPassiveGoal((PathfinderMob)this, 1.0, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackPassiveGoal((Guard)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new Guard.GuardMeleeGoal((Guard)this, 0.8, true));
        this.f_21345_.m_25352_(4, (Goal)new Guard.FollowHeroGoal((Guard)this));
        if (GuardConfig.GuardsRunFromPolarBears) {
            this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.0, 1.2));
        }
        this.f_21345_.m_25352_(4, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.5, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.5, false, 4, () -> false));
        if (GuardConfig.GuardsOpenDoors) {
            this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true){

                public void m_8056_() {
                    this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                    super.m_8056_();
                }
            });
        }
        if (GuardConfig.GuardFormation) {
            this.f_21345_.m_25352_(6, (Goal)new FollowShieldGuards((Guard)this));
        }
        if (GuardConfig.ClericHealing) {
            this.f_21345_.m_25352_(7, (Goal)new RunToClericGoal((Guard)this));
        }
        if (GuardConfig.armorerRepairGuardArmor) {
            this.f_21345_.m_25352_(7, (Goal)new ArmorerRepairGuardArmorGoal((Guard)this));
        }
        this.f_21345_.m_25352_(5, (Goal)new WalkBackToCheckPointGoal((Guard)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(5, (Goal)new Guard.DefendVillageGuardGoal((Guard)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guard.class, IronGolem.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HeroHurtByTargetGoal((Guard)this));
        this.f_21346_.m_25352_(3, (Goal)new HeroHurtTargetGoal((Guard)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Illusioner.class, true));
        if (GuardConfig.AttackAllMobs) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> mob instanceof Enemy && !GuardConfig.MobBlackList.contains(((Mob)mob).m_20078_())));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isAngryAt));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean isAngryAt(Object entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return super.m_21674_(living);
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUEST_NUMBER, (Object)QUEST_NUMBER.m_135015_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("QuestNumber", ((Integer)this.f_19804_.m_135370_(QUEST_NUMBER)).intValue());
        compound.m_128379_("SetQuestNumber", this.setQuestNumber);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        super.m_7378_(compound);
        if (compound.m_128441_("QuestNumber")) {
            this.f_19804_.m_135381_(QUEST_NUMBER, (Object)compound.m_128451_("QuestNumber"));
        }
        this.setQuestNumber = compound.m_128471_("SetQuestNumber");
    }

    public void setInteracting(boolean interacting) {
        this.isInteracting = interacting;
    }

    public boolean isInteracting() {
        return this.isInteracting;
    }

    public Player getInteractingPlayer() {
        return this.recentInteractingPlayer;
    }

    public void setInteractingPlayer(Player player) {
        this.recentInteractingPlayer = player;
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (player.m_36341_()) {
            return super.m_6071_(player, hand);
        }
        if (player instanceof ServerPlayer) {
            if (!this.setQuestNumber) {
                Random random = new Random();
                this.f_19804_.m_135381_(QUEST_NUMBER, (Object)QuestConfig.quests.guard_quests.get(random.nextInt(QuestConfig.quests.guard_quests.size())));
                this.setQuestNumber = true;
            }
            if (QuestVillager.tryAcceptGift((ServerPlayer)player, hand, this.getQuestNumber())) {
                player.m_21011_(hand, true);
            } else {
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41619_() && ReputationHandler.getReputation((Player)player, (Faction)ReputationHandler.getFaction((ResourceLocation)ResourceLocation.m_135820_((String)"reputation:villager"))) >= 0) {
                    PlayerPatch playerPatch = (PlayerPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (!playerPatch.isBattleMode()) {
                        this.interactQuest((ServerPlayer)player, hand);
                        this.isInteracting = true;
                        this.recentInteractingPlayer = player;
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("message.quest_giver.punch_locals"), player.m_142081_());
                    }
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    private void interactQuest(ServerPlayer player, InteractionHand hand) {
        Component name;
        QuestData quests2 = QuestData.get(player);
        Component component = name = this.m_8077_() ? this.m_7770_() : this.m_5446_();
        if (this.getQuestNumber() != null) {
            if (quests2.canComplete(this.getQuestNumber())) {
                QuestDisplay completionDisplay = Objects.requireNonNull(quests2.getQuestLine(this.getQuestNumber())).completePendingQuest();
                if (completionDisplay != null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(completionDisplay, false, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                    player.m_21011_(hand, true);
                    this.playRandomVillagerSound();
                } else {
                    List<SelectableQuest> active = Objects.requireNonNull(quests2.getQuestLine(this.getQuestNumber())).getQuests();
                    if (active.size() == 1) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(active.get((int)0).display, false, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                        player.m_21011_(hand, true);
                        this.playRandomVillagerSound();
                    } else if (!active.isEmpty()) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestSelectionSerializer.Message(name, this.getQuestNumber(), active, this.m_142538_(), this.m_142049_()));
                        player.m_21011_(hand, true);
                        this.playRandomVillagerSound();
                    } else if (!this.f_19853_.m_5776_()) {
                        this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                    }
                }
            } else {
                QuestDisplay initDisplay = quests2.initialize(this.getQuestNumber());
                if (initDisplay != null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(initDisplay, true, name, this.getQuestNumber(), this.m_142538_(), this.m_142049_()));
                    player.m_21011_(hand, true);
                    this.playRandomVillagerSound();
                } else if (!this.f_19853_.m_5776_()) {
                    this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                }
            }
        } else if (!this.f_19853_.m_5776_()) {
            this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
        }
    }

    public int getRandomNumber(int min, int max, int start) {
        this.setQuestNumber = true;
        Random random = new Random();
        int sum = max - min;
        int randomNumber = max - random.nextInt(sum);
        if (random.nextInt(sum + 1) <= 1) {
            return randomNumber;
        }
        return start;
    }

    protected void playRandomVillagerSound() {
        switch (this.f_19796_.nextInt(6)) {
            case 2: {
                this.m_5496_(SoundEvents.f_12508_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 3: {
                this.m_5496_(SoundEvents.f_12577_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 4: {
                this.m_5496_(SoundEvents.f_12509_, this.m_6121_(), this.m_6100_());
                break;
            }
            case 5: {
                this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
                break;
            }
            default: {
                this.m_5496_(SoundEvents.f_12503_, this.m_6121_(), this.m_6100_());
            }
        }
    }
}

