/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.quest_giver;

import com.feywild.quest_giver.QuestGiverMod;
import com.feywild.quest_giver.entity.GuildMasterProfession;
import com.feywild.quest_giver.entity.ModEntityTypes;
import com.feywild.quest_giver.entity.QuestVillager;
import com.feywild.quest_giver.item.TradingContract;
import com.feywild.quest_giver.network.quest.OpenQuestDisplaySerializer;
import com.feywild.quest_giver.network.quest.OpenQuestSelectionSerializer;
import com.feywild.quest_giver.network.quest.SyncRenders;
import com.feywild.quest_giver.quest.QuestDisplay;
import com.feywild.quest_giver.quest.QuestNumber;
import com.feywild.quest_giver.quest.player.QuestData;
import com.feywild.quest_giver.quest.player.QuestLineData;
import com.feywild.quest_giver.quest.task.BiomeTask;
import com.feywild.quest_giver.quest.task.CraftTask;
import com.feywild.quest_giver.quest.task.ItemPickupTask;
import com.feywild.quest_giver.quest.task.ItemStackTask;
import com.feywild.quest_giver.quest.task.KillTask;
import com.feywild.quest_giver.quest.task.StructureTask;
import com.feywild.quest_giver.quest.util.SelectableQuest;
import com.feywild.quest_giver.util.QuestGiverPlayerData;
import com.feywild.quest_giver.util.RenderEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class EventListener {
    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        ServerPlayer player;
        Entity entity;
        if (!event.getWorld().f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_146910_()) {
            EventListener.syncPlayerRenders(player);
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        QuestGiverPlayerData.copy(event.getOriginal(), event.getPlayer());
        event.getOriginal().invalidateCaps();
    }

    public static void syncPlayerRenders(ServerPlayer player) {
        QuestData data = QuestData.get(player);
        ArrayList<String> markedNumbers = new ArrayList<String>();
        StringBuilder packet = new StringBuilder();
        for (QuestNumber questNumber : data.getAllQuestLines().keySet()) {
            if (data.getQuestLine(questNumber) == null) continue;
            packet.append(EventListener.encodeStuff(Objects.requireNonNull(data.getQuestLine(questNumber)))).append("%");
            markedNumbers.add(questNumber.id);
        }
        for (QuestNumber numbers : QuestNumber.values()) {
            if (markedNumbers.contains(numbers.id)) continue;
            packet.append(numbers.id).append(",").append(RenderEnum.EXCLAMATION.getId()).append("%");
        }
        QuestGiverMod.getNetwork().sendTo(new SyncRenders(packet.substring(0, packet.length() - 1)), player);
    }

    private static String encodeStuff(QuestLineData data) {
        String id = RenderEnum.EXCLAMATION.getId();
        if (data.checkForEnd()) {
            id = RenderEnum.NONE.getId();
        } else if (!data.getActiveQuests().isEmpty()) {
            id = RenderEnum.QUESTION.getId();
        }
        return data.questNumber.id + "," + id;
    }

    @SubscribeEvent
    public static void pickupItem(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (int i = 0; i < event.getStack().m_41613_(); ++i) {
                QuestData.get(player2).checkComplete(ItemPickupTask.INSTANCE, event.getStack());
            }
        }
    }

    @SubscribeEvent
    public static void craftItem(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getCrafting();
        if (player instanceof ServerPlayer) {
            QuestData.get((ServerPlayer)player).checkComplete(CraftTask.INSTANCE, stack);
        }
    }

    @SubscribeEvent
    public static void playerKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            QuestData quests2 = QuestData.get(player);
            quests2.checkComplete(KillTask.INSTANCE, event.getEntityLiving().m_6095_());
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.player.f_19797_ % 20 == 0 && !event.player.f_19853_.f_46443_ && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestData quests2 = QuestData.get(player2);
            player2.m_150109_().f_35974_.forEach(stack -> quests2.checkComplete(ItemStackTask.INSTANCE, stack));
            quests2.checkComplete(BiomeTask.INSTANCE, (Biome)player2.m_183503_().m_204166_(player2.m_142538_()).m_203334_());
            if (player2.m_183503_().m_8595_().m_186605_(player2.m_142538_())) {
                player2.m_183503_().m_8595_().m_207815_(player2.m_142538_()).forEach((structure, set) -> quests2.checkComplete(StructureTask.INSTANCE, structure.f_65403_));
            }
        }
    }

    @SubscribeEvent
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getPlayer();
        if (player.m_36341_()) {
            return;
        }
        InteractionHand hand = event.getPlayer().m_7655_();
        Entity target = event.getTarget();
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            Villager villager;
            if (target instanceof Villager && (villager = (Villager)target).m_7141_().m_35571_() == GuildMasterProfession.GUILDMASTER.get() && !(target instanceof QuestVillager)) {
                Component name = villager.m_8077_() ? villager.m_7770_() : villager.m_5446_();
                QuestVillager entity = new QuestVillager(ModEntityTypes.questVillager, player.f_19853_);
                VillagerData villagerData = new VillagerData(VillagerType.m_204073_((Holder)player.f_19853_.m_204166_(player.m_142538_())), (VillagerProfession)GuildMasterProfession.GUILDMASTER.get(), 1);
                entity.m_141967_(villagerData);
                entity.m_6593_(name);
                entity.m_35546_(1);
                entity.m_20359_((Entity)villager);
                entity.setQuestNumber(14);
                player.m_183503_().m_7967_((Entity)entity);
                entity.m_7189_(player);
                villager.m_142687_(Entity.RemovalReason.DISCARDED);
                EventListener.interactQuest((ServerPlayer)player, hand, entity, entity.getQuestNumber());
            }
            if (target instanceof Villager && (villager = (Villager)target).m_7141_().m_35571_() != GuildMasterProfession.GUILDMASTER.get() && !(target instanceof QuestVillager)) {
                TradingContract contract;
                Item item = stack.m_41720_();
                if (item instanceof TradingContract && Objects.equals((contract = (TradingContract)item).getProfession(), villager.m_7141_().m_35571_().m_150028_()) && contract.isSignedByPlayer(player)) {
                    for (MerchantOffer merchantoffer : villager.m_6616_()) {
                        merchantoffer.m_45353_(-Mth.m_14143_((float)(40.0f * merchantoffer.m_45378_())));
                    }
                    villager.m_35536_(player);
                } else {
                    villager.m_5496_(SoundEvents.f_12507_, 1.0f, villager.m_6100_());
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void interactQuest(ServerPlayer player, InteractionHand hand, QuestVillager entity, QuestNumber questNumber) {
        QuestData quests2 = QuestData.get(player);
        if (entity.getQuestNumber() != null) {
            if (quests2.canComplete(entity.getQuestNumber())) {
                QuestDisplay completionDisplay = Objects.requireNonNull(quests2.getQuestLine(entity.getQuestNumber())).completePendingQuest();
                if (entity.getQuestTaker() == null) {
                    entity.setQuestTaker((Player)player);
                }
                if (completionDisplay != null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(completionDisplay, false, entity.m_5446_(), entity.getQuestNumber(), entity.m_142538_(), entity.m_142049_()));
                    player.m_21011_(hand, true);
                    EventListener.playRandomVillagerSound(entity);
                } else {
                    List<SelectableQuest> active = Objects.requireNonNull(quests2.getQuestLine(entity.getQuestNumber())).getQuests();
                    if (active.size() == 1) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(active.get((int)0).display, false, entity.m_5446_(), entity.getQuestNumber(), entity.m_142538_(), entity.m_142049_()));
                        player.m_21011_(hand, true);
                        EventListener.playRandomVillagerSound(entity);
                    } else if (!active.isEmpty()) {
                        QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestSelectionSerializer.Message(entity.m_5446_(), entity.getQuestNumber(), active, entity.m_142538_(), entity.m_142049_()));
                        player.m_21011_(hand, true);
                        EventListener.playRandomVillagerSound(entity);
                    } else {
                        entity.m_35319_(40);
                        if (!entity.f_19853_.m_5776_()) {
                            entity.m_5496_(SoundEvents.f_12507_, 1.0f, entity.m_6100_());
                        }
                    }
                }
            } else {
                QuestDisplay initDisplay = quests2.initialize(entity.getQuestNumber());
                if (initDisplay != null && entity.getQuestTaker() == null) {
                    QuestGiverMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(initDisplay, true, entity.m_5446_(), entity.getQuestNumber(), entity.m_142538_(), entity.m_142049_()));
                    player.m_21011_(hand, true);
                    EventListener.playRandomVillagerSound(entity);
                } else {
                    entity.m_35319_(40);
                    if (!entity.f_19853_.m_5776_()) {
                        entity.m_5496_(SoundEvents.f_12507_, 1.0f, entity.m_6100_());
                    }
                }
            }
        } else {
            entity.m_35319_(40);
            if (!entity.f_19853_.m_5776_()) {
                entity.m_5496_(SoundEvents.f_12507_, 1.0f, entity.m_6100_());
            }
        }
    }

    private static Villager findTarget(Level level, Player player) {
        double distance = Double.MAX_VALUE;
        TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
        Villager current = null;
        for (Villager villager : level.m_45971_(Villager.class, TARGETING, (LivingEntity)player, player.m_142469_().m_82400_(8.0))) {
            if (!(player.m_20280_((Entity)villager) < distance)) continue;
            current = villager;
            distance = player.m_20280_((Entity)villager);
        }
        return current;
    }

    protected static void playRandomVillagerSound(QuestVillager entity) {
        Random random = new Random();
        switch (random.nextInt(6)) {
            case 2: {
                entity.m_5496_(SoundEvents.f_12508_, 1.0f, 1.0f);
                break;
            }
            case 3: {
                entity.m_5496_(SoundEvents.f_12577_, 1.0f, 1.0f);
                break;
            }
            case 4: {
                entity.m_5496_(SoundEvents.f_12509_, 1.0f, 1.0f);
                break;
            }
            case 5: {
                entity.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            default: {
                entity.m_5496_(SoundEvents.f_12503_, 1.0f, 1.0f);
            }
        }
    }
}

