/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.world.ai;

import com.obscuria.obscureapi.world.ai.attack.Attack;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeAttackGoal
extends Goal {
    protected final PathfinderMob mob;
    protected final List<Attack> attacks;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private int update;
    private long lastCanUseCheck;
    public int attackTick = 0;

    public MeleeAttackGoal(PathfinderMob mob, double speed, boolean alwaysSees, Attack ... attacks) {
        this.mob = mob;
        this.attacks = List.of(attacks);
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = alwaysSees;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        return true;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.update = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distanceToSqr = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.update = Math.max(this.update - 1, 0);
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && this.update <= 0) {
                this.update = 4 + this.mob.m_21187_().nextInt(7);
                if (distanceToSqr > 1024.0) {
                    this.update += 10;
                } else if (distanceToSqr > 256.0) {
                    this.update += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                    this.update += 15;
                }
                this.update = this.m_183277_(this.update);
            }
            double distance = this.mob.m_20318_(1.0f).m_82554_(target.m_20318_(1.0f));
            this.attacks.forEach(attack -> {
                if (this.attackTick == 0 && attack.use((LivingEntity)this.mob, target, distance)) {
                    this.attackTick = attack.TICKS + 1;
                }
            });
            this.attacks.forEach(attack -> attack.tick((LivingEntity)this.mob, target, distance));
        }
    }
}

