/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScreenHelper {
    public static void drawWindow(PoseStack pose, WindowType type, int width, int height) {
        ScreenHelper.drawWindow(pose, type.getTexture(), width, height);
    }

    public static void drawWindow(PoseStack pose, ResourceLocation texture, int width, int height) {
        ScreenHelper.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)32, (int)32);
        GuiComponent.m_93133_((PoseStack)pose, (int)(16 + Math.max(width - 32, 0)), (int)0, (float)16.0f, (float)0.0f, (int)16, (int)16, (int)32, (int)32);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)(16 + Math.max(height - 32, 0)), (float)0.0f, (float)16.0f, (int)16, (int)16, (int)32, (int)32);
        GuiComponent.m_93133_((PoseStack)pose, (int)(16 + Math.max(width - 32, 0)), (int)(16 + Math.max(height - 32, 0)), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)32, (int)32);
        if (width > 32) {
            pose.m_85836_();
            pose.m_85837_(16.0, 0.0, 0.0);
            pose.m_85841_((float)(width - 32), 1.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)0.0f, (int)1, (int)16, (int)32, (int)32);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_(16.0, (double)(16 + Math.max(height - 32, 0)), 0.0);
            pose.m_85841_((float)(width - 32), 1.0f, 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)16.0f, (int)1, (int)16, (int)32, (int)32);
            pose.m_85849_();
        }
        if (height > 32) {
            pose.m_85836_();
            pose.m_85837_(0.0, 16.0, 0.0);
            pose.m_85841_(1.0f, (float)(height - 32), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)16.0f, (int)16, (int)1, (int)32, (int)32);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_((double)(16 + Math.max(width - 32, 0)), 16.0, 0.0);
            pose.m_85841_(1.0f, (float)(height - 32), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)16.0f, (int)16, (int)1, (int)32, (int)32);
            pose.m_85849_();
        }
        if (width > 32 && height > 32) {
            pose.m_85836_();
            pose.m_85837_(16.0, 16.0, 0.0);
            pose.m_85841_((float)(width - 32), (float)(height - 32), 1.0f);
            GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)16.0f, (float)16.0f, (int)1, (int)1, (int)32, (int)32);
            pose.m_85849_();
        }
        ScreenHelper.end();
    }

    public static void drawStyledWindow(PoseStack pose, int width, int height) {
        ScreenHelper.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("obscure_api:textures/gui/background.png"));
        GuiComponent.m_93133_((PoseStack)pose, (int)1, (int)1, (float)(320 - Math.round((float)(width - 2) / 2.0f)), (float)(180 - Math.round((float)(height - 2) / 2.0f)), (int)(width - 2), (int)(height - 2), (int)640, (int)360);
        ScreenHelper.end();
        ScreenHelper.drawWindow(pose, new ResourceLocation("obscure_api:textures/gui/background_border_0.png"), width + 2, height + 2);
        ScreenHelper.drawWindow(pose, new ResourceLocation("obscure_api:textures/gui/background_border_1.png"), width, height);
    }

    public static void drawText(List<Component> lines, Font font, PoseStack pose) {
        int i = 0;
        for (Component line : lines) {
            Objects.requireNonNull(font);
            font.m_92889_(pose, line, 0.0f, (float)(i * 9), 0);
            ++i;
        }
    }

    public static float scale() {
        return switch (Minecraft.m_91087_().f_91066_.f_92072_) {
            default -> 1.0f;
            case 2 -> 0.5f;
            case 3 -> 0.666666f;
            case 4 -> 0.75f;
        };
    }

    public static void start(float r, float g, float b, float a) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void start() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void end() {
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum WindowType {
        COMMON(0),
        FLAT(1),
        HEADER(2);

        private final int type;

        private WindowType(int type) {
            this.type = type;
        }

        public ResourceLocation getTexture() {
            return new ResourceLocation("obscure_api:textures/gui/window_" + this.type + ".png");
        }
    }
}

