/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.registry;

import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ObscureAPIAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ATTRIBUTES, (String)"obscure_api");
    public static final RegistryObject<Attribute> CRITICAL_HIT = REGISTRY.register("critical_hit", () -> new RangedAttribute("obscure_api.criticalHit", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> CRITICAL_DAMAGE = REGISTRY.register("critical_damage", () -> new RangedAttribute("obscure_api.criticalDamage", 2.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> DODGE = REGISTRY.register("dodge", () -> new RangedAttribute("obscure_api.dodge", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> PARRY = REGISTRY.register("parry", () -> new RangedAttribute("obscure_api.parry", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_DAMAGE = REGISTRY.register("magic_damage", () -> new RangedAttribute("obscure_api.magicDamage", 0.0, 0.0, 100000.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_RESISTANCE = REGISTRY.register("magic_resistance", () -> new RangedAttribute("obscure_api.magicResistance", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> PENETRATION = REGISTRY.register("penetration", () -> new RangedAttribute("obscure_api.penetration", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> REGENERATION = REGISTRY.register("regeneration", () -> new RangedAttribute("obscure_api.regeneration", 0.0, 0.0, 100000.0).m_22084_(true));
    public static final RegistryObject<Attribute> HEALING_POWER = REGISTRY.register("healing_power", () -> new RangedAttribute("obscure_api.healingPower", 1.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> ACCURACY = REGISTRY.register("accuracy", () -> new RangedAttribute("obscure_api.accuracy", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> RESILIENCE = REGISTRY.register("resilience", () -> new RangedAttribute("obscure_api.resilience", 0.0, 0.0, 100.0).m_22084_(true));

    public static float getCriticalHit(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)CRITICAL_HIT.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)CRITICAL_HIT.get(), 0.0f, 0.0f, 1.0f) : 0.0f;
    }

    public static float getCriticalDamage(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)CRITICAL_DAMAGE.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)CRITICAL_DAMAGE.get(), 0.0f, 0.0f, 10.0f) : 2.0f;
    }

    public static float getDodge(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)DODGE.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)DODGE.get(), 0.0f, 0.0f, 0.8f) : 0.0f;
    }

    public static float getParry(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)PARRY.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)PARRY.get(), 0.0f, 0.0f, 0.8f) : 0.0f;
    }

    public static float getMagicDamage(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)MAGIC_DAMAGE.get()) ? ObscureAPIAttributes.getValue(entity, (Attribute)MAGIC_DAMAGE.get(), 0.0f, 0.0f, 999999.0f) : 0.0f;
    }

    public static float getMagicResistance(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)MAGIC_RESISTANCE.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)MAGIC_RESISTANCE.get(), 0.0f, 0.0f, 0.8f) : 0.0f;
    }

    public static float getPenetration(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)PENETRATION.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)PENETRATION.get(), 0.0f, 0.0f, 1.0f) : 0.0f;
    }

    public static float getAccuracy(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)ACCURACY.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)ACCURACY.get(), 0.0f, 0.0f, 1.0f) : 0.0f;
    }

    public static float getRegeneration(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)REGENERATION.get()) ? ObscureAPIAttributes.getValue(entity, (Attribute)REGENERATION.get(), 0.0f, 0.0f, 99.0f) : 0.0f;
    }

    public static float getHealingPower(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)HEALING_POWER.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)HEALING_POWER.get(), 0.0f, 0.0f, 10.0f) : 1.0f;
    }

    public static float getResilience(LivingEntity entity) {
        return entity.m_21204_().m_22171_((Attribute)RESILIENCE.get()) ? ObscureAPIAttributes.getPercent(entity, (Attribute)RESILIENCE.get(), 0.0f, 0.0f, 0.5f) : 0.0f;
    }

    public static float getPercent(@NotNull LivingEntity entity, Attribute attr, float base, float min, float max) {
        double amount = entity.m_21172_(attr);
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.ADDITION)) {
            amount += attribute.m_22218_();
        }
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            amount += attribute.m_22218_();
        }
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            amount += attribute.m_22218_();
        }
        for (MobEffectInstance effect2 : entity.m_21220_()) {
            for (Map.Entry entry : effect2.m_19544_().m_19485_().entrySet()) {
                if (entry.getKey() != attr) continue;
                amount += ((AttributeModifier)entry.getValue()).m_22218_() * (double)(effect2.m_19564_() + 1);
            }
        }
        return Math.max(min, Math.min(max, base + (float)amount));
    }

    public static float getValue(@NotNull LivingEntity entity, Attribute attr, float base, float min, float max) {
        double baseAmount = entity.m_21172_(attr);
        double amount = 0.0;
        double modBase = 1.0;
        double modTotal = 1.0;
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.ADDITION)) {
            amount += attribute.m_22218_();
        }
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            modBase += attribute.m_22218_();
        }
        for (AttributeModifier attribute : Objects.requireNonNull(entity.m_21051_(attr)).m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            modTotal += attribute.m_22218_();
        }
        for (MobEffectInstance effect2 : entity.m_21220_()) {
            for (Map.Entry entry : effect2.m_19544_().m_19485_().entrySet()) {
                if (entry.getKey() == attr && ((AttributeModifier)entry.getValue()).m_22217_() == AttributeModifier.Operation.ADDITION) {
                    amount += ((AttributeModifier)entry.getValue()).m_22218_() * (double)(effect2.m_19564_() + 1);
                }
                if (entry.getKey() == attr && ((AttributeModifier)entry.getValue()).m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                    modBase += ((AttributeModifier)entry.getValue()).m_22218_() * (double)(effect2.m_19564_() + 1);
                }
                if (entry.getKey() != attr || ((AttributeModifier)entry.getValue()).m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
                modTotal += ((AttributeModifier)entry.getValue()).m_22218_() * (double)(effect2.m_19564_() + 1);
            }
        }
        return Math.max(min, Math.min(max, base + (float)((baseAmount * modBase + amount) * modTotal)));
    }
}

