/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi;

import com.obscuria.obscureapi.ObscureAPI;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ObscureAPIConfig {
    public static void init() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "Obscuria");
        try {
            Files.createDirectory(modConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ObscureAPI.LOGGER.error("Failed to create Obscuria config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.CLIENT_SPEC, "Obscuria/obscure-api-client.toml");
    }

    public static class Client {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec CLIENT_SPEC;
        public static final ForgeConfigSpec.BooleanValue foodIcons;
        public static final ForgeConfigSpec.BooleanValue equipmentIcons;

        static {
            BUILDER.push("Tooltips");
            foodIcons = BUILDER.comment("Display food properties in tooltips").worldRestart().define("Food Icons", true);
            equipmentIcons = BUILDER.comment("Display equipment attributes in tooltips").worldRestart().define("Equipment Icons", true);
            BUILDER.pop();
            CLIENT_SPEC = BUILDER.build();
        }
    }
}

