/*
 * Decompiled with CFR 0.152.
 */
package reascer.efdg.skill;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import reascer.efdg.gameasset.EFAnimations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EarthquakeSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b19d1eb4-fefa-11ec-b939-0242ac12000");
    public static final SkillDataManager.SkillDataKey<Boolean> SUPERARMOR = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);

    public EarthquakeSkill(Skill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(SUPERARMOR);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(SUPERARMOR)).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.playAnimationSynchronized(EFAnimations.GREATSWORD_DUAL_EARTHQUAKE, 0.0f);
        executer.getSkill((Skill)this).getDataManager().setDataSync(SUPERARMOR, (Object)true, (ServerPlayer)executer.getOriginal());
        super.executeOnServer(executer, args);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Swing:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Slam :");
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (((Boolean)container.getDataManager().getDataValue(SUPERARMOR)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
        }
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }
}

